"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const Button_module = require("./Button.module.css.cjs");
const UnstyledButton = require("./UnstyledButton.cjs");
const Button = React.forwardRef(function Button2({
  as,
  kind: kindProp = "primary",
  size = "lg",
  children,
  className,
  iconOnly,
  Icon,
  destructive: destructiveProp,
  disabled,
  ...props
}, ref) {
  const [kind, destructive] = kindProp === "destructive" ? ["secondary", true] : [kindProp, destructiveProp];
  const classes = classNames(Button_module.default.button, className, {
    [Button_module.default["has-icon"]]: Icon,
    [Button_module.default["icon-only"]]: iconOnly,
    [Button_module.default.destructive]: destructive
  });
  const iconSize = iconOnly && size === "lg" ? 24 : 20;
  return /* @__PURE__ */ jsxRuntime.jsxs(
    UnstyledButton.UnstyledButton,
    {
      ...props,
      as: as || "button",
      ref,
      className: classes,
      "data-size": size,
      "data-kind": kind,
      tabIndex: 0,
      disabled,
      children: [
        Icon && /* @__PURE__ */ jsxRuntime.jsx(
          Icon,
          {
            width: iconSize,
            height: iconSize,
            className: Button_module.default.icon,
            "aria-hidden": true
          }
        ),
        children
      ]
    }
  );
});
exports.Button = Button;
//# sourceMappingURL=Button.cjs.map
