import { jsxs, jsx } from "react/jsx-runtime";
import Chevron from "@vector-im/compound-design-tokens/assets/web/icons/chevron-left";
import styles from "./Breadcrumb.module.css.js";
import { Link } from "../Link/Link.js";
import classNames from "classnames";
import { IconButton } from "../Button/IconButton/IconButton.js";
function Breadcrumb({
  backLabel,
  onBackClick,
  pages,
  onPageClick,
  className,
  ...props
}) {
  return /* @__PURE__ */ jsxs("nav", { className: classNames(styles.breadcrumb, className), ...props, children: [
    /* @__PURE__ */ jsx(
      IconButton,
      {
        kind: "secondary",
        size: "28px",
        "aria-label": backLabel,
        onClick: onBackClick,
        children: /* @__PURE__ */ jsx(Chevron, {})
      }
    ),
    /* @__PURE__ */ jsx("ol", { className: styles.pages, children: pages.map((page, index) => /* @__PURE__ */ jsx(
      Page,
      {
        page,
        isLastPage: index === pages.length - 1,
        onClick: () => onPageClick(page, index)
      },
      index
    )) })
  ] });
}
function Page({ page, isLastPage, onClick }) {
  const onKeyDown = (event) => {
    if (event.key === " ") {
      onClick();
    }
  };
  return /* @__PURE__ */ jsx("li", { children: isLastPage ? /* @__PURE__ */ jsx("span", { className: styles["last-page"], "aria-current": "page", children: page }) : /* @__PURE__ */ jsx(
    Link,
    {
      size: "small",
      role: "button",
      onClick,
      onKeyDown,
      tabIndex: 0,
      children: page
    }
  ) });
}
export {
  Breadcrumb
};
//# sourceMappingURL=Breadcrumb.js.map
