"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const Chevron = require("@vector-im/compound-design-tokens/assets/web/icons/chevron-left");
const Breadcrumb_module = require("./Breadcrumb.module.css.cjs");
const Link = require("../Link/Link.cjs");
const classNames = require("classnames");
const IconButton = require("../Button/IconButton/IconButton.cjs");
function Breadcrumb({
  backLabel,
  onBackClick,
  pages,
  onPageClick,
  className,
  ...props
}) {
  return /* @__PURE__ */ jsxRuntime.jsxs("nav", { className: classNames(Breadcrumb_module.default.breadcrumb, className), ...props, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      IconButton.IconButton,
      {
        kind: "secondary",
        size: "28px",
        "aria-label": backLabel,
        onClick: onBackClick,
        children: /* @__PURE__ */ jsxRuntime.jsx(Chevron, {})
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("ol", { className: Breadcrumb_module.default.pages, children: pages.map((page, index) => /* @__PURE__ */ jsxRuntime.jsx(
      Page,
      {
        page,
        isLastPage: index === pages.length - 1,
        onClick: () => onPageClick(page, index)
      },
      index
    )) })
  ] });
}
function Page({ page, isLastPage, onClick }) {
  const onKeyDown = (event) => {
    if (event.key === " ") {
      onClick();
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsx("li", { children: isLastPage ? /* @__PURE__ */ jsxRuntime.jsx("span", { className: Breadcrumb_module.default["last-page"], "aria-current": "page", children: page }) : /* @__PURE__ */ jsxRuntime.jsx(
    Link.Link,
    {
      size: "small",
      role: "button",
      onClick,
      onKeyDown,
      tabIndex: 0,
      children: page
    }
  ) });
}
exports.Breadcrumb = Breadcrumb;
//# sourceMappingURL=Breadcrumb.cjs.map
