import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import styles from "./Badge.module.css.js";
import { Typography } from "../Typography/Typography.js";
const Badge = ({
  children,
  kind = "default",
  className
}) => {
  const classes = classNames(styles.badge, className);
  return /* @__PURE__ */ jsx(
    Typography,
    {
      as: "span",
      size: "sm",
      weight: "medium",
      className: classes,
      "data-kind": kind,
      children
    }
  );
};
export {
  Badge
};
//# sourceMappingURL=Badge.js.map
