"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const Badge_module = require("./Badge.module.css.cjs");
const Typography = require("../Typography/Typography.cjs");
const Badge = ({
  children,
  kind = "default",
  className
}) => {
  const classes = classNames(Badge_module.default.badge, className);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Typography.Typography,
    {
      as: "span",
      size: "sm",
      weight: "medium",
      className: classes,
      "data-kind": kind,
      children
    }
  );
};
exports.Badge = Badge;
//# sourceMappingURL=Badge.cjs.map
