import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import { useEffect } from "react";
import styles from "./Avatar.module.css.js";
import clipMask from "./avatar-clip.mask.svg.js";
const AVATAR_MASK_ID = "cpdAvatarClipSvg";
let AvatarStackUsageCount = 0;
const AvatarStack = ({ children, className }) => {
  useEffect(() => {
    if (AvatarStackUsageCount === 0) {
      const svgMask = `
        <div aria-hidden="true" id="${AVATAR_MASK_ID}" class="${styles["clip-path"]}">
          ${clipMask}
        </div>
      `;
      document.body.insertAdjacentHTML("beforeend", svgMask);
    }
    AvatarStackUsageCount++;
    return () => {
      AvatarStackUsageCount--;
      if (AvatarStackUsageCount <= 0) {
        document.getElementById(AVATAR_MASK_ID)?.remove();
      }
    };
  }, []);
  return /* @__PURE__ */ jsx("div", { className: classNames(styles["stacked-avatars"], className), children });
};
export {
  AvatarStack
};
//# sourceMappingURL=AvatarStack.js.map
