"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const Avatar_module = require("./Avatar.module.css.cjs");
const avatarClip_mask = require("./avatar-clip.mask.svg.cjs");
const AVATAR_MASK_ID = "cpdAvatarClipSvg";
let AvatarStackUsageCount = 0;
const AvatarStack = ({ children, className }) => {
  React.useEffect(() => {
    if (AvatarStackUsageCount === 0) {
      const svgMask = `
        <div aria-hidden="true" id="${AVATAR_MASK_ID}" class="${Avatar_module.default["clip-path"]}">
          ${avatarClip_mask.default}
        </div>
      `;
      document.body.insertAdjacentHTML("beforeend", svgMask);
    }
    AvatarStackUsageCount++;
    return () => {
      AvatarStackUsageCount--;
      if (AvatarStackUsageCount <= 0) {
        document.getElementById(AVATAR_MASK_ID)?.remove();
      }
    };
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: classNames(Avatar_module.default["stacked-avatars"], className), children });
};
exports.AvatarStack = AvatarStack;
//# sourceMappingURL=AvatarStack.cjs.map
