import { jsx } from "react/jsx-runtime";
import classNames from "classnames";
import React, { forwardRef } from "react";
import { getInitialLetter } from "../../utils/string.js";
import styles from "./Avatar.module.css.js";
import { useIdColorHash } from "./useIdColorHash.js";
function shouldBeAButton(props) {
  return !!(props.onClick || props.onKeyDown || props.onKeyUp);
}
const Avatar = forwardRef(function Avatar2({
  src,
  id,
  name = "",
  type = "round",
  className = "",
  size,
  style = {},
  onError,
  ...props
}, ref) {
  return React.createElement(
    shouldBeAButton(props) ? "button" : "span",
    {
      ref,
      role: "img",
      // Default the aria-label to id
      "aria-label": id,
      ...props,
      "data-type": type,
      "data-color": useIdColorHash(id),
      className: classNames(styles.avatar, className, {
        [styles["avatar-imageless"]]: !src
      }),
      style: {
        ...style,
        "--cpd-avatar-size": size
      }
    },
    /* @__PURE__ */ jsx(React.Fragment, { children: !src ? getInitialLetter(name) : /* @__PURE__ */ jsx(
      "img",
      {
        loading: "lazy",
        alt: "",
        src,
        referrerPolicy: "no-referrer",
        className: classNames(styles.image),
        "data-type": type,
        style,
        width: size,
        height: size,
        onError
      }
    ) })
  );
});
export {
  Avatar
};
//# sourceMappingURL=Avatar.js.map
