"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const string = require("../../utils/string.cjs");
const Avatar_module = require("./Avatar.module.css.cjs");
const useIdColorHash = require("./useIdColorHash.cjs");
function shouldBeAButton(props) {
  return !!(props.onClick || props.onKeyDown || props.onKeyUp);
}
const Avatar = React.forwardRef(function Avatar2({
  src,
  id,
  name = "",
  type = "round",
  className = "",
  size,
  style = {},
  onError,
  ...props
}, ref) {
  return React.createElement(
    shouldBeAButton(props) ? "button" : "span",
    {
      ref,
      role: "img",
      // Default the aria-label to id
      "aria-label": id,
      ...props,
      "data-type": type,
      "data-color": useIdColorHash.useIdColorHash(id),
      className: classNames(Avatar_module.default.avatar, className, {
        [Avatar_module.default["avatar-imageless"]]: !src
      }),
      style: {
        ...style,
        "--cpd-avatar-size": size
      }
    },
    /* @__PURE__ */ jsxRuntime.jsx(React.Fragment, { children: !src ? string.getInitialLetter(name) : /* @__PURE__ */ jsxRuntime.jsx(
      "img",
      {
        loading: "lazy",
        alt: "",
        src,
        referrerPolicy: "no-referrer",
        className: classNames(Avatar_module.default.image),
        "data-type": type,
        style,
        width: size,
        height: size,
        onError
      }
    ) })
  );
});
exports.Avatar = Avatar;
//# sourceMappingURL=Avatar.cjs.map
