import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { useCallback } from "react";
import CheckCircleIcon from "@vector-im/compound-design-tokens/assets/web/icons/check-circle";
import ErrorIcon from "@vector-im/compound-design-tokens/assets/web/icons/error-solid";
import InfoIcon from "@vector-im/compound-design-tokens/assets/web/icons/info";
import CloseIcon from "@vector-im/compound-design-tokens/assets/web/icons/close";
import styles from "./Alert.module.css.js";
import { Text } from "../Typography/Text.js";
import { IconButton } from "../Button/IconButton/IconButton.js";
const Alert = ({
  type,
  title,
  children,
  className,
  actions,
  onClose,
  ...props
}) => {
  const classes = classNames(styles.alert, className);
  const renderIcon = useCallback(
    (props2) => {
      switch (type) {
        case "critical":
          return /* @__PURE__ */ jsx(ErrorIcon, { ...props2 });
        case "info":
          return /* @__PURE__ */ jsx(InfoIcon, { ...props2 });
        case "success":
          return /* @__PURE__ */ jsx(CheckCircleIcon, { ...props2 });
      }
    },
    [type]
  );
  return /* @__PURE__ */ jsxs("div", { ...props, className: classes, "data-type": type, children: [
    renderIcon({
      width: 24,
      height: 24,
      className: styles.icon,
      "aria-hidden": true
    }),
    /* @__PURE__ */ jsxs("div", { className: styles.content, children: [
      /* @__PURE__ */ jsxs("div", { className: styles["text-content"], children: [
        /* @__PURE__ */ jsx(Text, { size: "md", weight: "semibold", children: title }),
        /* @__PURE__ */ jsx(Text, { size: "sm", weight: "regular", children })
      ] }),
      actions && /* @__PURE__ */ jsx("div", { className: styles.actions, children: actions })
    ] }),
    onClose && /* @__PURE__ */ jsx(
      IconButton,
      {
        onClick: onClose,
        "aria-label": "Close",
        role: "button",
        className: styles.close,
        children: /* @__PURE__ */ jsx(CloseIcon, {})
      }
    )
  ] });
};
export {
  Alert
};
//# sourceMappingURL=Alert.js.map
