"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const jsxRuntime = require("react/jsx-runtime");
const classNames = require("classnames");
const React = require("react");
const CheckCircleIcon = require("@vector-im/compound-design-tokens/assets/web/icons/check-circle");
const ErrorIcon = require("@vector-im/compound-design-tokens/assets/web/icons/error-solid");
const InfoIcon = require("@vector-im/compound-design-tokens/assets/web/icons/info");
const CloseIcon = require("@vector-im/compound-design-tokens/assets/web/icons/close");
const Alert_module = require("./Alert.module.css.cjs");
const Text = require("../Typography/Text.cjs");
const IconButton = require("../Button/IconButton/IconButton.cjs");
const Alert = ({
  type,
  title,
  children,
  className,
  actions,
  onClose,
  ...props
}) => {
  const classes = classNames(Alert_module.default.alert, className);
  const renderIcon = React.useCallback(
    (props2) => {
      switch (type) {
        case "critical":
          return /* @__PURE__ */ jsxRuntime.jsx(ErrorIcon, { ...props2 });
        case "info":
          return /* @__PURE__ */ jsxRuntime.jsx(InfoIcon, { ...props2 });
        case "success":
          return /* @__PURE__ */ jsxRuntime.jsx(CheckCircleIcon, { ...props2 });
      }
    },
    [type]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...props, className: classes, "data-type": type, children: [
    renderIcon({
      width: 24,
      height: 24,
      className: Alert_module.default.icon,
      "aria-hidden": true
    }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: Alert_module.default.content, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: Alert_module.default["text-content"], children: [
        /* @__PURE__ */ jsxRuntime.jsx(Text.Text, { size: "md", weight: "semibold", children: title }),
        /* @__PURE__ */ jsxRuntime.jsx(Text.Text, { size: "sm", weight: "regular", children })
      ] }),
      actions && /* @__PURE__ */ jsxRuntime.jsx("div", { className: Alert_module.default.actions, children: actions })
    ] }),
    onClose && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton.IconButton,
      {
        onClick: onClose,
        "aria-label": "Close",
        role: "button",
        className: Alert_module.default.close,
        children: /* @__PURE__ */ jsxRuntime.jsx(CloseIcon, {})
      }
    )
  ] });
};
exports.Alert = Alert;
//# sourceMappingURL=Alert.cjs.map
