"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageManagerCommand = exports.PM = void 0;
exports.getCollectorByPackageManager = getCollectorByPackageManager;
exports.getNodeModules = getNodeModules;
exports.detectPackageManager = detectPackageManager;
const npmNodeModulesCollector_1 = require("./npmNodeModulesCollector");
const pnpmNodeModulesCollector_1 = require("./pnpmNodeModulesCollector");
const yarnNodeModulesCollector_1 = require("./yarnNodeModulesCollector");
const packageManager_1 = require("./packageManager");
Object.defineProperty(exports, "PM", { enumerable: true, get: function () { return packageManager_1.PM; } });
Object.defineProperty(exports, "getPackageManagerCommand", { enumerable: true, get: function () { return packageManager_1.getPackageManagerCommand; } });
async function getCollectorByPackageManager(pm, rootDir, tempDirManager) {
    switch (pm) {
        case packageManager_1.PM.PNPM:
            if (await pnpmNodeModulesCollector_1.PnpmNodeModulesCollector.isPnpmProjectHoisted(rootDir)) {
                return new npmNodeModulesCollector_1.NpmNodeModulesCollector(rootDir, tempDirManager);
            }
            return new pnpmNodeModulesCollector_1.PnpmNodeModulesCollector(rootDir, tempDirManager);
        case packageManager_1.PM.NPM:
            return new npmNodeModulesCollector_1.NpmNodeModulesCollector(rootDir, tempDirManager);
        case packageManager_1.PM.YARN:
            return new yarnNodeModulesCollector_1.YarnNodeModulesCollector(rootDir, tempDirManager);
        default:
            return new npmNodeModulesCollector_1.NpmNodeModulesCollector(rootDir, tempDirManager);
    }
}
async function getNodeModules(pm, rootDir, tempDirManager) {
    const collector = await getCollectorByPackageManager(pm, rootDir, tempDirManager);
    return collector.getNodeModules();
}
function detectPackageManager(dirs) {
    let pm = null;
    for (const dir of dirs) {
        pm = (0, packageManager_1.detectPackageManagerByLockfile)(dir);
        if (pm) {
            return pm;
        }
    }
    return (0, packageManager_1.detectPackageManagerByEnv)("pnpm") || (0, packageManager_1.detectPackageManagerByEnv)("yarn") || (0, packageManager_1.detectPackageManagerByEnv)("npm") || packageManager_1.PM.NPM;
}
//# sourceMappingURL=index.js.map