import * as React from 'react';

declare type Props$1 = React.HTMLAttributes<HTMLDivElement> & {
    hash: string;
    /** CSS height, default: 128 */
    height?: number | string | 'auto';
    punch?: number;
    resolutionX?: number;
    resolutionY?: number;
    style?: React.CSSProperties;
    /** CSS width, default: 128 */
    width?: number | string | 'auto';
};
declare class Blurhash extends React.PureComponent<Props$1> {
    static defaultProps: {
        height: number;
        width: number;
        resolutionX: number;
        resolutionY: number;
    };
    componentDidUpdate(): void;
    render(): JSX.Element;
}

declare type Props = React.CanvasHTMLAttributes<HTMLCanvasElement> & {
    hash: string;
    height?: number;
    punch?: number;
    width?: number;
};
declare class BlurhashCanvas extends React.PureComponent<Props> {
    static defaultProps: {
        height: number;
        width: number;
    };
    canvas: HTMLCanvasElement;
    componentDidUpdate(): void;
    handleRef: (canvas: HTMLCanvasElement) => void;
    draw: () => void;
    render(): JSX.Element;
}

export { Blurhash, BlurhashCanvas };
