/// <reference types="node" />
/// <reference types="node" />
import type { Span } from '@opentelemetry/api';
import type { Scope } from '@sentry/core';
import type EventEmitter from 'events';
import type { ClientRequest, IncomingMessage, Server, ServerResponse } from 'http';
/**
 * Instrument a server to capture incoming requests.
 *
 */
export declare function instrumentServer(server: Server, { ignoreIncomingRequestBody, ignoreSpansForIncomingRequests, maxIncomingRequestBodySize, trackIncomingRequestsAsSessions, spans, ignoreStaticAssets, sessionFlushingDelayMS, instrumentation, incomingRequestSpanHook, }: {
    ignoreIncomingRequestBody?: (url: string, request: IncomingMessage) => boolean;
    ignoreSpansForIncomingRequests?: (urlPath: string, request: IncomingMessage) => boolean;
    maxIncomingRequestBodySize?: 'small' | 'medium' | 'always' | 'none';
    trackIncomingRequestsAsSessions?: boolean;
    sessionFlushingDelayMS: number;
    spans: boolean;
    ignoreStaticAssets?: boolean;
    incomingRequestSpanHook?: (span: Span, request: IncomingMessage, response: ServerResponse) => void;
    /** @deprecated Use `incomingRequestSpanHook` instead. */
    instrumentation?: {
        requestHook?: (span: Span, req: IncomingMessage | ClientRequest) => void;
        responseHook?: (span: Span, response: ServerResponse | IncomingMessage) => void;
        applyCustomAttributesOnSpan?: (span: Span, request: IncomingMessage | ClientRequest, response: ServerResponse | IncomingMessage) => void;
    };
}): void;
/**
 * Starts a session and tracks it in the context of a given isolation scope.
 * When the passed response is finished, the session is put into a task and is
 * aggregated with other sessions that may happen in a certain time window
 * (sessionFlushingDelayMs).
 *
 * The sessions are always aggregated by the client that is on the current scope
 * at the time of ending the response (if there is one).
 */
export declare function recordRequestSession({ requestIsolationScope, response, sessionFlushingDelayMS, }: {
    requestIsolationScope: Scope;
    response: EventEmitter;
    sessionFlushingDelayMS?: number;
}): void;
/**
 * Check if a request is for a common static asset that should be ignored by default.
 *
 * Only exported for tests.
 */
export declare function isStaticAssetRequest(urlPath: string): boolean;
//# sourceMappingURL=incoming-requests.d.ts.map