import { InstrumentationBase, InstrumentationNodeModuleDefinition } from '@opentelemetry/instrumentation';
/**
 * Hono instrumentation for OpenTelemetry
 */
export declare class HonoInstrumentation extends InstrumentationBase {
    constructor();
    /**
     * Initialize the instrumentation.
     */
    init(): InstrumentationNodeModuleDefinition[];
    /**
     * Patches the module exports to instrument Hono.
     */
    private _patch;
    /**
     * Patches the route handler to instrument it.
     */
    private _patchHandler;
    /**
     * Patches the 'on' handler to instrument it.
     */
    private _patchOnHandler;
    /**
     * Patches the middleware handler to instrument it.
     */
    private _patchMiddlewareHandler;
}
//# sourceMappingURL=instrumentation.d.ts.map