import { HonoInstrumentation } from './instrumentation';
export declare const instrumentHono: ((options?: unknown) => HonoInstrumentation) & {
    id: string;
};
/**
 * Adds Sentry tracing instrumentation for [Hono](https://hono.dev/).
 *
 * If you also want to capture errors, you need to call `setupHonoErrorHandler(app)` after you set up your Hono server.
 *
 * For more information, see the [hono documentation](https://docs.sentry.io/platforms/javascript/guides/hono/).
 *
 * @example
 * ```javascript
 * const Sentry = require('@sentry/node');
 *
 * Sentry.init({
 *   integrations: [Sentry.honoIntegration()],
 * })
 * ```
 */
export declare const honoIntegration: () => import("@sentry/core").Integration;
//# sourceMappingURL=index.d.ts.map