import { InstrumentationConfig, InstrumentationModuleDefinition, InstrumentationBase } from '@opentelemetry/instrumentation';
import { AnthropicAiOptions, Integration } from '@sentry/core';
export interface AnthropicAiIntegration extends Integration {
    options: AnthropicAiOptions;
}
/**
 * Sentry Anthropic AI instrumentation using OpenTelemetry.
 */
export declare class SentryAnthropicAiInstrumentation extends InstrumentationBase<InstrumentationConfig> {
    constructor(config?: InstrumentationConfig);
    /**
     * Initializes the instrumentation by defining the modules to be patched.
     */
    init(): InstrumentationModuleDefinition;
    /**
     * Core patch logic applying instrumentation to the Anthropic AI client constructor.
     */
    private _patch;
}
//# sourceMappingURL=instrumentation.d.ts.map
