import { defineIntegration, SEMANTIC_ATTRIBUTE_SENTRY_OP } from '@sentry/core';
import { generateInstrumentOnce, addOriginToSpan } from '@sentry/node-core';
import { FirebaseInstrumentation } from './otel/firebaseInstrumentation.js';

const INTEGRATION_NAME = 'Firebase';

const config = {
  firestoreSpanCreationHook: span => {
    addOriginToSpan(span , 'auto.firebase.otel.firestore');

    span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_OP, 'db.query');
  },
};

const instrumentFirebase = generateInstrumentOnce(INTEGRATION_NAME, () => new FirebaseInstrumentation(config));

const _firebaseIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentFirebase();
    },
  };
}) ;

const firebaseIntegration = defineIntegration(_firebaseIntegration);

export { firebaseIntegration, instrumentFirebase };
//# sourceMappingURL=firebase.js.map
