import { VectorTileFeature, VectorTileLayer, type VectorTile } from '@mapbox/vector-tile';
import type { TileFeature, AnyProps } from 'supercluster';
import { type Feature as GeoJSONVTFeature } from 'geojson-vt';
export type Feature = TileFeature<AnyProps, AnyProps> | GeoJSONVTFeature;
export interface GeoJSONOptions {
    version: number;
    extent: number;
}
export declare class GeoJSONWrapper extends VectorTileLayer implements VectorTile {
    layers: Record<string, VectorTileLayer>;
    name: string;
    extent: number;
    length: number;
    version: number;
    features: Feature[];
    constructor(features: Feature[], options?: GeoJSONOptions);
    feature(i: number): VectorTileFeature;
}
