import { type GeoJSONOptions, type Feature, GeoJSONWrapper } from './lib/geojson_wrapper';
import geojsonvt from 'geojson-vt';
import { type VectorTile } from '@mapbox/vector-tile';
/**
 * Serialize a vector-tile-js-created tile to pbf
 *
 * @param tile
 * @return uncompressed, pbf-serialized tile data
 */
export declare function fromVectorTileJs(tile: VectorTile): Uint8Array;
/**
 * Serialized a geojson-vt-created tile to pbf.
 *
 * @param layers - An object mapping layer names to geojson-vt-created vector tile objects
 * @param options - An object specifying the vector-tile specification version and extent that were used to create `layers`.
 * @return uncompressed, pbf-serialized tile data
 */
export declare function fromGeojsonVt(layers: geojsonvt.Tile[], options?: GeoJSONOptions): Uint8Array;
export { GeoJSONWrapper, GeoJSONOptions, Feature };
