"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toUtf16 = void 0;
function toUtf16(text) {
    const limit = text.length * 2;
    const bytes = new Uint8Array(limit);
    for (let i = 0; i < limit; i++) {
        const v = text.charCodeAt(i >> 1);
        bytes[i++] = v;
        bytes[i] = v >> 8;
    }
    return bytes;
}
exports.toUtf16 = toUtf16;
exports.default = toUtf16;
//# sourceMappingURL=toUtf16.cjs.map