"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  xxHash32: () => xxHash32
});
module.exports = __toCommonJS(src_exports);

// src/xxHash32.ts
var PRIME32_1 = 2654435761;
var PRIME32_2 = 2246822519;
var PRIME32_3 = 3266489917;
var PRIME32_4 = 668265263;
var PRIME32_5 = 374761393;
var encoder;
function xxHash32(input, seed = 0) {
  const buffer = typeof input === "string" ? (encoder ??= new TextEncoder()).encode(input) : input;
  const b = buffer;
  let acc = seed + PRIME32_5 & 4294967295;
  let offset = 0;
  if (b.length >= 16) {
    const accN = [
      seed + PRIME32_1 + PRIME32_2 & 4294967295,
      seed + PRIME32_2 & 4294967295,
      seed + 0 & 4294967295,
      seed - PRIME32_1 & 4294967295
    ];
    const b2 = buffer;
    const limit2 = b2.length - 16;
    let lane = 0;
    for (offset = 0; (offset & 4294967280) <= limit2; offset += 4) {
      const i = offset;
      const laneN0 = b2[i + 0] + (b2[i + 1] << 8);
      const laneN1 = b2[i + 2] + (b2[i + 3] << 8);
      const laneNP = laneN0 * PRIME32_2 + (laneN1 * PRIME32_2 << 16);
      let acc2 = accN[lane] + laneNP & 4294967295;
      acc2 = acc2 << 13 | acc2 >>> 19;
      const acc0 = acc2 & 65535;
      const acc1 = acc2 >>> 16;
      accN[lane] = acc0 * PRIME32_1 + (acc1 * PRIME32_1 << 16) & 4294967295;
      lane = lane + 1 & 3;
    }
    acc = (accN[0] << 1 | accN[0] >>> 31) + (accN[1] << 7 | accN[1] >>> 25) + (accN[2] << 12 | accN[2] >>> 20) + (accN[3] << 18 | accN[3] >>> 14) & 4294967295;
  }
  acc = acc + buffer.length & 4294967295;
  const limit = buffer.length - 4;
  for (; offset <= limit; offset += 4) {
    const i = offset;
    const laneN0 = b[i + 0] + (b[i + 1] << 8);
    const laneN1 = b[i + 2] + (b[i + 3] << 8);
    const laneP = laneN0 * PRIME32_3 + (laneN1 * PRIME32_3 << 16);
    acc = acc + laneP & 4294967295;
    acc = acc << 17 | acc >>> 15;
    acc = (acc & 65535) * PRIME32_4 + ((acc >>> 16) * PRIME32_4 << 16) & 4294967295;
  }
  for (; offset < b.length; ++offset) {
    const lane = b[offset];
    acc = acc + lane * PRIME32_5;
    acc = acc << 11 | acc >>> 21;
    acc = (acc & 65535) * PRIME32_1 + ((acc >>> 16) * PRIME32_1 << 16) & 4294967295;
  }
  acc = acc ^ acc >>> 15;
  acc = ((acc & 65535) * PRIME32_2 & 4294967295) + ((acc >>> 16) * PRIME32_2 << 16);
  acc = acc ^ acc >>> 13;
  acc = ((acc & 65535) * PRIME32_3 & 4294967295) + ((acc >>> 16) * PRIME32_3 << 16);
  acc = acc ^ acc >>> 16;
  return acc < 0 ? acc + 4294967296 : acc;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  xxHash32
});
