import { Api, ModuleExport } from './api';
/**
 * Error thrown when a module is incompatible with the engine version.
 * @public
 */
export declare class ModuleIncompatibleError extends Error {
    constructor(pluginVersion: string);
}
/**
 * A module loader for loading and starting modules.
 * @public
 */
export declare class ModuleLoader {
    private api;
    private modules;
    private started;
    constructor(api: Api);
    load(moduleExport: ModuleExport): Promise<void>;
    start(): Promise<void>;
}
//# sourceMappingURL=loader.d.ts.map