/**
 * Utility class to wrap a value and allow listeners to be notified when the value changes.
 * If T is an object, it will use a shallow comparison to determine if the value has changed.
 * @public
 */
export declare class Watchable<T> {
    private currentValue;
    private readonly listeners;
    constructor(currentValue: T);
    get value(): T;
    set value(value: T);
    watch(listener: (value: T) => void): void;
    unwatch(listener: (value: T) => void): void;
}
/**
 * A React hook to use an updated Watchable value.
 * @param watchable - The Watchable instance to watch.
 * @returns The live value of the Watchable.
 * @public
 */
export declare function useWatchable<T>(watchable: Watchable<T>): T;
//# sourceMappingURL=watchable.d.ts.map