import { Root } from 'react-dom/client';
import { LegacyModuleApiExtension } from './legacy-modules';
import { LegacyCustomisationsApiExtension } from './legacy-customisations';
import { ConfigApi } from './config';
import { I18nApi } from './i18n';
import { CustomComponentsApi } from './custom-components';
import { NavigationApi } from './navigation.ts';
import { DialogApiExtension } from './dialog.ts';
import { AccountAuthApiExtension } from './auth.ts';
import { ProfileApiExtension } from './profile.ts';
/**
 * Module interface for modules to implement.
 * @public
 */
export interface Module {
    load(): Promise<void>;
}
/**
 * Module interface for modules to export as the default export.
 * @public
 */
export interface ModuleFactory {
    readonly moduleApiVersion: string;
    new (api: Api): Module;
    readonly prototype: Module;
}
export interface ModuleExport {
    default: ModuleFactory;
}
export declare function isModule(module: unknown): module is ModuleExport;
/**
 * The API for modules to interact with the application.
 * @public
 */
export interface Api extends LegacyModuleApiExtension, LegacyCustomisationsApiExtension, DialogApiExtension, AccountAuthApiExtension, ProfileApiExtension {
    /**
     * The API to read config.json values.
     * Keys should be scoped to the module in reverse domain name notation.
     * @public
     */
    readonly config: ConfigApi;
    /**
     * The internationalisation API.
     * @public
     */
    readonly i18n: I18nApi;
    /**
     * The root node the main application is rendered to.
     * Intended for rendering sibling React trees.
     * @public
     */
    readonly rootNode: HTMLElement;
    /**
     * The custom message component API.
     * @alpha
     */
    readonly customComponents: CustomComponentsApi;
    /**
     * API to navigate the application.
     * @public
     */
    readonly navigation: NavigationApi;
    /**
     * Create a ReactDOM root for rendering React components.
     * Exposed to allow modules to avoid needing to bundle their own ReactDOM.
     * @param element - the element to render use as the root.
     * @public
     */
    createRoot(element: Element): Root;
}
//# sourceMappingURL=index.d.ts.map