/**
 * The translations for the module.
 * @public
 */
export type Translations = Record<string, {
    [ietfLanguageTag: string]: string;
}>;
/**
 * Variables to interpolate into a translation.
 * @public
 */
export type Variables = {
    /**
     * The number of items to count for pluralised translations
     */
    count?: number;
    [key: string]: number | string | undefined;
};
/**
 * The API for interacting with translations.
 * @public
 */
export interface I18nApi {
    /**
     * Read the current language of the user in IETF Language Tag format
     */
    get language(): string;
    /**
     * Register translations for the module, may override app's existing translations
     */
    register(translations: Partial<Translations>): void;
    /**
     * Perform a translation, with optional variables
     * @param key - The key to translate
     * @param variables - Optional variables to interpolate into the translation
     */
    translate(key: keyof Translations, variables?: Variables): string;
}
//# sourceMappingURL=i18n.d.ts.map