/**
 * Interface for account authentication information, used for overwriting the current account's authentication state.
 * @public
 */
export interface AccountAuthInfo {
    /**
     * The user ID.
     */
    userId: string;
    /**
     * The device ID.
     */
    deviceId: string;
    /**
     * The access token belonging to this device ID and user ID.
     */
    accessToken: string;
    /**
     * The refresh token belonging to this device ID and user ID.
     */
    refreshToken?: string;
    /**
     * The homeserver URL where the credentials are valid.
     */
    homeserverUrl: string;
}
/**
 * Methods to manage authentication in the application.
 * @public
 */
export interface AccountAuthApiExtension {
    /**
     * Overwrite the current account's authentication state with the provided account information.
     * @param accountInfo - The account authentication information to overwrite the current state with.
     */
    overwriteAccountAuth(accountInfo: AccountAuthInfo): Promise<void>;
}
//# sourceMappingURL=auth.d.ts.map