import type { Compiler, WebpackPluginInstance } from 'webpack';
declare namespace HtmlWebpackInjectPreload {
    interface Options {
        files: HtmlWebpackInjectPreload.File[];
    }
    interface File {
        match: RegExp;
        attributes: Record<string, string | boolean>;
    }
}
/**
 * Inject preload files before the content of the targeted files
 *
 * @example
 * new HtmlWebpackInjectPreload({
 *  files: [
 *    {
 *      match: /.*\.woff2/$,
 *      attributes: { rel: 'preload', as: 'font', type: 'font/woff2',
 * crossorigin: true },
 *    },
 *    {
 *      match: /vendors\.[a-z-0-9]*.css/$,
 *      attributes: { rel: 'preload', as: 'style' },
 *    },
 *  ],
 * })
 *
 * @class InjectPreloadFiles
 */
declare class HtmlWebpackInjectPreload implements WebpackPluginInstance {
    private options;
    /**
     * Creates an instance of HtmlWebpackInjectPreload.
     *
     * @memberof InjectPreloadFiles
     */
    constructor(options: HtmlWebpackInjectPreload.Options);
    /**
     * Extract HTMLWebpack Plugin by jahed
     *
     * @param compiler
     */
    private extractHtmlWebpackPluginModule;
    private addLinks;
    apply(compiler: Compiler): void;
}
export = HtmlWebpackInjectPreload;
