import { Client } from '../client';
import { Scope } from '../scope';
import { Span } from '../types-hoist/span';
import { SerializedTraceData } from '../types-hoist/tracing';
/**
 * Extracts trace propagation data from the current span or from the client's scope (via transaction or propagation
 * context) and serializes it to `sentry-trace` and `baggage` values. These values can be used to propagate
 * a trace via our tracing Http headers or Html `<meta>` tags.
 *
 * This function also applies some validation to the generated sentry-trace and baggage values to ensure that
 * only valid strings are returned.
 *
 * If (@param options.propagateTraceparent) is `true`, the function will also generate a `traceparent` value,
 * following the W3C traceparent header format.
 *
 * @returns an object with the tracing data values. The object keys are the name of the tracing key to be used as header
 * or meta tag name.
 */
export declare function getTraceData(options?: {
    span?: Span;
    scope?: Scope;
    client?: Client;
    propagateTraceparent?: boolean;
}): SerializedTraceData;
/**
 * Builds a W3C traceparent header from the given sentry-trace header.
 *
 * Why parse that header and not create traceparent from primitives?
 * We want these two headers to always have the same ids. The easiest way to do this is to take
 * one of them as the source of truth (sentry-trace) and derive the other from it.
 *
 * Most importantly, this guarantees parentSpanId consistency between sentry-trace and traceparent
 * in tracing without performance (TwP) mode, where we always generate a random parentSpanId.
 *
 * Exported for testing
 */
export declare function _sentryTraceToTraceParentHeader(sentryTrace: string): string | undefined;
//# sourceMappingURL=traceData.d.ts.map
