# Installation
> `npm install --save @types/counterpart`

# Summary
This package contains type definitions for counterpart (https://github.com/martinandert/counterpart).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/counterpart.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/counterpart/index.d.ts)
````ts
type NotFoundHandler = (locale: string, key: string, fallback: string, scope: string) => void;
type LocaleChangeHandler = (newLocale: string, oldLocale: string) => void;

interface Counterpart {
    (key: string | string[], options?: object): string;
    translate(key: string | string[], options?: object): string;

    setSeparator(value: string): string;
    onTranslationNotFound(callback: NotFoundHandler): void;
    offTranslationNotFound(callback: NotFoundHandler): void;
    setMissingEntryGenerator(callback: (value: string) => void): void;
    getLocale(): string;
    setLocale(value: string): string;
    onLocaleChange(callback: LocaleChangeHandler): void;
    offLocaleChange(callback: LocaleChangeHandler): void;
    setFallbackLocale(value: string | string[]): void;
    registerTranslations(locale: string, data: object): void;
    registerInterpolations(data: object): void;
    setKeyTransformer(callback: (value: string, options: object) => string): string;
    localize(date: Date, options: object): string;
    Instance: Counterpart;
    Translator: Counterpart;
}

declare var counterpart: Counterpart;

export = counterpart;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: none

# Credits
These definitions were written by [santiagodoldan](https://github.com/santiagodoldan).
