"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextUpdate = exports.SuggestionPattern = exports.Selection = exports.ReplaceAll = exports.PatternKeyType = exports.PatternKey = exports.MenuStateUpdate = exports.MenuState = exports.MenuActionSuggestion = exports.MenuAction = exports.LinkAction = exports.Keep = exports.HtmlSource = exports.Edit = exports.DomHandle = exports.DomCreationError = exports.DomChildren = exports.Disabled = exports.CreateWithText = exports.Create = exports.ComposerUpdate = exports.ComposerModel = exports.ComposerAction = exports.ActionState = void 0;
exports.__wbg_body_942ea927546a04ba = __wbg_body_942ea927546a04ba;
exports.__wbg_childNodes_c4423003f3a9441f = __wbg_childNodes_c4423003f3a9441f;
exports.__wbg_error_7534b8e9a36f1ab4 = __wbg_error_7534b8e9a36f1ab4;
exports.__wbg_forEach_d6a05ca96422eff9 = __wbg_forEach_d6a05ca96422eff9;
exports.__wbg_forEach_e1cf6f7c8ecb7dae = __wbg_forEach_e1cf6f7c8ecb7dae;
exports.__wbg_getAttribute_ea5166be2deba45e = __wbg_getAttribute_ea5166be2deba45e;
exports.__wbg_getPropertyValue_e623c23a05dfb30c = __wbg_getPropertyValue_e623c23a05dfb30c;
exports.__wbg_get_e27dfaeb6f46bd45 = __wbg_get_e27dfaeb6f46bd45;
exports.__wbg_hasAttribute_db31090c2e646f57 = __wbg_hasAttribute_db31090c2e646f57;
exports.__wbg_length_49b2ba67f0897e97 = __wbg_length_49b2ba67f0897e97;
exports.__wbg_new_363ae9575a2aba54 = __wbg_new_363ae9575a2aba54;
exports.__wbg_new_5e0be73521bc8c17 = __wbg_new_5e0be73521bc8c17;
exports.__wbg_new_8a6f238a6ece86ea = __wbg_new_8a6f238a6ece86ea;
exports.__wbg_nodeName_ff3aa439a5af6311 = __wbg_nodeName_ff3aa439a5af6311;
exports.__wbg_nodeType_5e1153141daac26a = __wbg_nodeType_5e1153141daac26a;
exports.__wbg_nodeValue_6ff4f14870c43bd9 = __wbg_nodeValue_6ff4f14870c43bd9;
exports.__wbg_parseFromString_91cbec9ba27a222a = __wbg_parseFromString_91cbec9ba27a222a;
exports.__wbg_set_8fc6bf8a5b1071d1 = __wbg_set_8fc6bf8a5b1071d1;
exports.__wbg_set_wasm = __wbg_set_wasm;
exports.__wbg_stack_0ed75d68575b0f3c = __wbg_stack_0ed75d68575b0f3c;
exports.__wbg_style_fb30c14e5815805c = __wbg_style_fb30c14e5815805c;
exports.__wbindgen_init_externref_table = __wbindgen_init_externref_table;
exports.__wbindgen_number_new = __wbindgen_number_new;
exports.__wbindgen_string_get = __wbindgen_string_get;
exports.__wbindgen_string_new = __wbindgen_string_new;
exports.__wbindgen_throw = __wbindgen_throw;
exports.new_composer_model = new_composer_model;
exports.new_composer_model_from_html = new_composer_model_from_html;
exports.start = start;
let wasm;
function __wbg_set_wasm(val) {
  wasm = val;
}
function isLikeNone(x) {
  return x === undefined || x === null;
}
function addToExternrefTable0(obj) {
  const idx = wasm.__externref_table_alloc();
  wasm.__wbindgen_export_1.set(idx, obj);
  return idx;
}
const lTextDecoder = typeof TextDecoder === 'undefined' ? (0, module.require)('util').TextDecoder : TextDecoder;
let cachedTextDecoder = new lTextDecoder('utf-8', {
  ignoreBOM: true,
  fatal: true
});
cachedTextDecoder.decode();
let cachedUint8ArrayMemory0 = null;
function getUint8ArrayMemory0() {
  if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
    cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8ArrayMemory0;
}
function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}
let WASM_VECTOR_LEN = 0;
const lTextEncoder = typeof TextEncoder === 'undefined' ? (0, module.require)('util').TextEncoder : TextEncoder;
let cachedTextEncoder = new lTextEncoder('utf-8');
const encodeString = typeof cachedTextEncoder.encodeInto === 'function' ? function (arg, view) {
  return cachedTextEncoder.encodeInto(arg, view);
} : function (arg, view) {
  const buf = cachedTextEncoder.encode(arg);
  view.set(buf);
  return {
    read: arg.length,
    written: buf.length
  };
};
function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === undefined) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr = malloc(buf.length, 1) >>> 0;
    getUint8ArrayMemory0().subarray(ptr, ptr + buf.length).set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr;
  }
  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;
  const mem = getUint8ArrayMemory0();
  let offset = 0;
  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 0x7F) break;
    mem[ptr + offset] = code;
  }
  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
    const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);
    offset += ret.written;
    ptr = realloc(ptr, len, offset, 1) >>> 0;
  }
  WASM_VECTOR_LEN = offset;
  return ptr;
}
let cachedDataViewMemory0 = null;
function getDataViewMemory0() {
  if (cachedDataViewMemory0 === null || cachedDataViewMemory0.buffer.detached === true || cachedDataViewMemory0.buffer.detached === undefined && cachedDataViewMemory0.buffer !== wasm.memory.buffer) {
    cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
  }
  return cachedDataViewMemory0;
}
function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    const idx = addToExternrefTable0(e);
    wasm.__wbindgen_exn_store(idx);
  }
}
function start() {
  wasm.start();
}

/**
 * @returns {ComposerModel}
 */
function new_composer_model() {
  const ret = wasm.composermodel_new();
  return ComposerModel.__wrap(ret);
}

/**
 * @param {string} html
 * @param {number} start_utf16_codeunit
 * @param {number} end_utf16_codeunit
 * @returns {ComposerModel}
 */
function new_composer_model_from_html(html, start_utf16_codeunit, end_utf16_codeunit) {
  const ptr0 = passStringToWasm0(html, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len0 = WASM_VECTOR_LEN;
  const ret = wasm.new_composer_model_from_html(ptr0, len0, start_utf16_codeunit, end_utf16_codeunit);
  return ComposerModel.__wrap(ret);
}
function _assertClass(instance, klass) {
  if (!(instance instanceof klass)) {
    throw new Error(`expected instance of ${klass.name}`);
  }
}
function takeFromExternrefTable0(idx) {
  const value = wasm.__wbindgen_export_1.get(idx);
  wasm.__externref_table_dealloc(idx);
  return value;
}
function __wbg_adapter_124(arg0, arg1, arg2, arg3, arg4) {
  wasm.closure102_externref_shim(arg0, arg1, arg2, arg3, arg4);
}
function __wbg_adapter_127(arg0, arg1, arg2, arg3) {
  wasm.closure105_externref_shim(arg0, arg1, arg2, arg3);
}

/**
 * @enum {0 | 1 | 2}
 */
const ActionState = exports.ActionState = Object.freeze({
  /**
   * The button can be clicked, and will perform its normal action
   * e.g. make something bold
   */
  Enabled: 0,
  "0": "Enabled",
  /**
   * The button can be clicked, and will perform the reverse of its
   * normal action e.g. stop something being bold
   */
  Reversed: 1,
  "1": "Reversed",
  /**
   * The button cannot be clicked
   */
  Disabled: 2,
  "2": "Disabled"
});
/**
 * @enum {0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13}
 */
const ComposerAction = exports.ComposerAction = Object.freeze({
  Bold: 0,
  "0": "Bold",
  Italic: 1,
  "1": "Italic",
  StrikeThrough: 2,
  "2": "StrikeThrough",
  Underline: 3,
  "3": "Underline",
  InlineCode: 4,
  "4": "InlineCode",
  Link: 5,
  "5": "Link",
  Undo: 6,
  "6": "Undo",
  Redo: 7,
  "7": "Redo",
  OrderedList: 8,
  "8": "OrderedList",
  UnorderedList: 9,
  "9": "UnorderedList",
  Indent: 10,
  "10": "Indent",
  Unindent: 11,
  "11": "Unindent",
  CodeBlock: 12,
  "12": "CodeBlock",
  Quote: 13,
  "13": "Quote"
});
/**
 * @enum {0 | 1}
 */
const DomCreationError = exports.DomCreationError = Object.freeze({
  HtmlParseError: 0,
  "0": "HtmlParseError",
  MarkdownParseError: 1,
  "1": "MarkdownParseError"
});
/**
 * @enum {0 | 1 | 2}
 */
const HtmlSource = exports.HtmlSource = Object.freeze({
  Matrix: 0,
  "0": "Matrix",
  GoogleDoc: 1,
  "1": "GoogleDoc",
  UnknownExternal: 2,
  "2": "UnknownExternal"
});
/**
 * @enum {0 | 1 | 2 | 3 | 4}
 */
const PatternKeyType = exports.PatternKeyType = Object.freeze({
  At: 0,
  "0": "At",
  Hash: 1,
  "1": "Hash",
  Slash: 2,
  "2": "Slash",
  Custom: 3,
  "3": "Custom",
  Colon: 4,
  "4": "Colon"
});
const __wbindgen_enum_SupportedType = ["text/html", "text/xml", "application/xml", "application/xhtml+xml", "image/svg+xml"];
const ComposerModelFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_composermodel_free(ptr >>> 0, 1));
class ComposerModel {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ComposerModel.prototype);
    obj.__wbg_ptr = ptr;
    ComposerModelFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ComposerModelFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_composermodel_free(ptr, 0);
  }
  /**
   * @returns {ComposerModel}
   */
  static new() {
    const ret = wasm.composermodel_new();
    return ComposerModel.__wrap(ret);
  }
  /**
   * @param {string} text
   * @returns {ComposerModel}
   */
  static from_example_format(text) {
    const ptr0 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_from_example_format(ptr0, len0);
    return ComposerModel.__wrap(ret);
  }
  /**
   * @returns {string}
   */
  to_example_format() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_to_example_format(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  get_content_as_html() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_get_content_as_html(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  get_content_as_message_html() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_get_content_as_message_html(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  get_content_as_markdown() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_get_content_as_markdown(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  get_content_as_message_markdown() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_get_content_as_message_markdown(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {string}
   */
  get_content_as_plain_text() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.composermodel_get_content_as_plain_text(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {DomHandle}
   */
  document() {
    const ret = wasm.composermodel_document(this.__wbg_ptr);
    return DomHandle.__wrap(ret);
  }
  /**
   * @returns {Map<any, any>}
   */
  action_states() {
    const ret = wasm.composermodel_action_states(this.__wbg_ptr);
    return ret;
  }
  /**
   * @param {number} start_utf16_codeunit
   * @param {number} end_utf16_codeunit
   * @returns {ComposerUpdate}
   */
  select(start_utf16_codeunit, end_utf16_codeunit) {
    const ret = wasm.composermodel_select(this.__wbg_ptr, start_utf16_codeunit, end_utf16_codeunit);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {number}
   */
  selection_start() {
    const ret = wasm.composermodel_selection_start(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @returns {number}
   */
  selection_end() {
    const ret = wasm.composermodel_selection_end(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {string} new_text
   * @returns {ComposerUpdate}
   */
  replace_text(new_text) {
    const ptr0 = passStringToWasm0(new_text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_replace_text(this.__wbg_ptr, ptr0, len0);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @param {string} new_html
   * @param {HtmlSource} external_source
   * @returns {ComposerUpdate}
   */
  replace_html(new_html, external_source) {
    const ptr0 = passStringToWasm0(new_html, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_replace_html(this.__wbg_ptr, ptr0, len0, external_source);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @param {string} new_text
   * @param {SuggestionPattern} suggestion
   * @param {boolean} append_space
   * @returns {ComposerUpdate}
   */
  replace_text_suggestion(new_text, suggestion, append_space) {
    const ptr0 = passStringToWasm0(new_text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    _assertClass(suggestion, SuggestionPattern);
    const ret = wasm.composermodel_replace_text_suggestion(this.__wbg_ptr, ptr0, len0, suggestion.__wbg_ptr, append_space);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @param {string} text
   * @returns {ComposerUpdate}
   */
  set_content_from_html(text) {
    const ptr0 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_set_content_from_html(this.__wbg_ptr, ptr0, len0);
    if (ret[2]) {
      throw takeFromExternrefTable0(ret[1]);
    }
    return ComposerUpdate.__wrap(ret[0]);
  }
  /**
   * @param {string} text
   * @returns {ComposerUpdate}
   */
  set_content_from_markdown(text) {
    const ptr0 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_set_content_from_markdown(this.__wbg_ptr, ptr0, len0);
    if (ret[2]) {
      throw takeFromExternrefTable0(ret[1]);
    }
    return ComposerUpdate.__wrap(ret[0]);
  }
  /**
   * @returns {ComposerUpdate}
   */
  clear() {
    const ret = wasm.composermodel_clear(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  enter() {
    const ret = wasm.composermodel_enter(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  backspace() {
    const ret = wasm.composermodel_backspace(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  backspace_word() {
    const ret = wasm.composermodel_backspace_word(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  delete() {
    const ret = wasm.composermodel_delete(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  delete_word() {
    const ret = wasm.composermodel_delete_word(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  bold() {
    const ret = wasm.composermodel_bold(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  italic() {
    const ret = wasm.composermodel_italic(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  strike_through() {
    const ret = wasm.composermodel_strike_through(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  underline() {
    const ret = wasm.composermodel_underline(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  quote() {
    const ret = wasm.composermodel_quote(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  inline_code() {
    const ret = wasm.composermodel_inline_code(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  code_block() {
    const ret = wasm.composermodel_code_block(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  undo() {
    const ret = wasm.composermodel_undo(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  redo() {
    const ret = wasm.composermodel_redo(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  ordered_list() {
    const ret = wasm.composermodel_ordered_list(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  unordered_list() {
    const ret = wasm.composermodel_unordered_list(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  indent() {
    const ret = wasm.composermodel_indent(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  unindent() {
    const ret = wasm.composermodel_unindent(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {LinkAction}
   */
  get_link_action() {
    const ret = wasm.composermodel_get_link_action(this.__wbg_ptr);
    return LinkAction.__wrap(ret);
  }
  /**
   * @param {string} url
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  set_link(url, attributes) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_set_link(this.__wbg_ptr, ptr0, len0, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @param {string} url
   * @param {string} text
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  set_link_with_text(url, text, attributes) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ptr1 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_set_link_with_text(this.__wbg_ptr, ptr0, len0, ptr1, len1, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @param {Array<any>} custom_suggestion_patterns
   */
  set_custom_suggestion_patterns(custom_suggestion_patterns) {
    wasm.composermodel_set_custom_suggestion_patterns(this.__wbg_ptr, custom_suggestion_patterns);
  }
  /**
   * Creates an at-room mention node and inserts it into the composer at the current selection
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  insert_at_room_mention(attributes) {
    const ret = wasm.composermodel_insert_at_room_mention(this.__wbg_ptr, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * Creates a mention node and inserts it into the composer at the current selection
   * @param {string} url
   * @param {string} text
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  insert_mention(url, text, attributes) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ptr1 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    const ret = wasm.composermodel_insert_mention(this.__wbg_ptr, ptr0, len0, ptr1, len1, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * Creates an at-room mention node and inserts it into the composer, replacing the
   * text content defined by the suggestion
   * @param {SuggestionPattern} suggestion
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  insert_at_room_mention_at_suggestion(suggestion, attributes) {
    _assertClass(suggestion, SuggestionPattern);
    const ret = wasm.composermodel_insert_at_room_mention_at_suggestion(this.__wbg_ptr, suggestion.__wbg_ptr, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * Creates a mention node and inserts it into the composer, replacing the
   * text content defined by the suggestion
   * @param {string} url
   * @param {string} text
   * @param {SuggestionPattern} suggestion
   * @param {Map<any, any>} attributes
   * @returns {ComposerUpdate}
   */
  insert_mention_at_suggestion(url, text, suggestion, attributes) {
    const ptr0 = passStringToWasm0(url, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ptr1 = passStringToWasm0(text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    _assertClass(suggestion, SuggestionPattern);
    const ret = wasm.composermodel_insert_mention_at_suggestion(this.__wbg_ptr, ptr0, len0, ptr1, len1, suggestion.__wbg_ptr, attributes);
    return ComposerUpdate.__wrap(ret);
  }
  /**
   * @returns {ComposerUpdate}
   */
  remove_links() {
    const ret = wasm.composermodel_remove_links(this.__wbg_ptr);
    return ComposerUpdate.__wrap(ret);
  }
}
exports.ComposerModel = ComposerModel;
const ComposerUpdateFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_composerupdate_free(ptr >>> 0, 1));
class ComposerUpdate {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ComposerUpdate.prototype);
    obj.__wbg_ptr = ptr;
    ComposerUpdateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ComposerUpdateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_composerupdate_free(ptr, 0);
  }
  /**
   * @returns {TextUpdate}
   */
  text_update() {
    const ret = wasm.composerupdate_text_update(this.__wbg_ptr);
    return TextUpdate.__wrap(ret);
  }
  /**
   * @returns {MenuState}
   */
  menu_state() {
    const ret = wasm.composerupdate_menu_state(this.__wbg_ptr);
    return MenuState.__wrap(ret);
  }
  /**
   * @returns {MenuAction}
   */
  menu_action() {
    const ret = wasm.composerupdate_menu_action(this.__wbg_ptr);
    return MenuAction.__wrap(ret);
  }
}
exports.ComposerUpdate = ComposerUpdate;
const CreateFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_create_free(ptr >>> 0, 1));
class Create {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(Create.prototype);
    obj.__wbg_ptr = ptr;
    CreateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CreateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_create_free(ptr, 0);
  }
}
exports.Create = Create;
const CreateWithTextFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_createwithtext_free(ptr >>> 0, 1));
class CreateWithText {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(CreateWithText.prototype);
    obj.__wbg_ptr = ptr;
    CreateWithTextFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    CreateWithTextFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_createwithtext_free(ptr, 0);
  }
}
exports.CreateWithText = CreateWithText;
const DisabledFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_disabled_free(ptr >>> 0, 1));
class Disabled {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(Disabled.prototype);
    obj.__wbg_ptr = ptr;
    DisabledFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    DisabledFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_disabled_free(ptr, 0);
  }
}
exports.Disabled = Disabled;
const DomChildrenFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_domchildren_free(ptr >>> 0, 1));
/**
 * An iterator-like view of a DomHandle's children, written to work around
 * the lack of support for returning Vec<T> in wasm_bindgen.
 */
class DomChildren {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(DomChildren.prototype);
    obj.__wbg_ptr = ptr;
    DomChildrenFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    DomChildrenFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_domchildren_free(ptr, 0);
  }
  /**
   * @returns {DomHandle | undefined}
   */
  next_child() {
    const ret = wasm.domchildren_next_child(this.__wbg_ptr);
    return ret === 0 ? undefined : DomHandle.__wrap(ret);
  }
}
exports.DomChildren = DomChildren;
const DomHandleFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_domhandle_free(ptr >>> 0, 1));
/**
 * Refers to a node in the composer model.
 */
class DomHandle {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(DomHandle.prototype);
    obj.__wbg_ptr = ptr;
    DomHandleFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    DomHandleFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_domhandle_free(ptr, 0);
  }
  /**
   * Returns "container", "line_break", "text" or "zwsp" depending on the type of
   * node we refer to.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   * @param {ComposerModel} model
   * @returns {string}
   */
  node_type(model) {
    let deferred1_0;
    let deferred1_1;
    try {
      _assertClass(model, ComposerModel);
      const ret = wasm.domhandle_node_type(this.__wbg_ptr, model.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * Returns a list of our children nodes, or an empty list if we refer
   * to a text or line break node.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   * @param {ComposerModel} model
   * @returns {DomChildren}
   */
  children(model) {
    _assertClass(model, ComposerModel);
    const ret = wasm.domhandle_children(this.__wbg_ptr, model.__wbg_ptr);
    return DomChildren.__wrap(ret);
  }
  /**
   * Returns the text of this node, or an empty string if this is a
   * container or line break.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   * @param {ComposerModel} model
   * @returns {string}
   */
  text(model) {
    let deferred1_0;
    let deferred1_1;
    try {
      _assertClass(model, ComposerModel);
      const ret = wasm.domhandle_text(this.__wbg_ptr, model.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * Returns our tagname, or "-text-"/"-zwsp-" if we are a text/zwsp node.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   * @param {ComposerModel} model
   * @returns {string}
   */
  tag(model) {
    let deferred1_0;
    let deferred1_1;
    try {
      _assertClass(model, ComposerModel);
      const ret = wasm.domhandle_tag(this.__wbg_ptr, model.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
}
exports.DomHandle = DomHandle;
const EditFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_edit_free(ptr >>> 0, 1));
class Edit {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(Edit.prototype);
    obj.__wbg_ptr = ptr;
    EditFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    EditFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_edit_free(ptr, 0);
  }
  /**
   * @returns {string}
   */
  get url() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.__wbg_get_edit_url(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @param {string} arg0
   */
  set url(arg0) {
    const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_edit_url(this.__wbg_ptr, ptr0, len0);
  }
}
exports.Edit = Edit;
const KeepFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_keep_free(ptr >>> 0, 1));
class Keep {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(Keep.prototype);
    obj.__wbg_ptr = ptr;
    KeepFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    KeepFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_keep_free(ptr, 0);
  }
}
exports.Keep = Keep;
const LinkActionFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_linkaction_free(ptr >>> 0, 1));
class LinkAction {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(LinkAction.prototype);
    obj.__wbg_ptr = ptr;
    LinkActionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    LinkActionFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_linkaction_free(ptr, 0);
  }
  /**
   * @returns {CreateWithText | undefined}
   */
  get create_with_text() {
    const ret = wasm.__wbg_get_linkaction_create_with_text(this.__wbg_ptr);
    return ret === 0 ? undefined : CreateWithText.__wrap(ret);
  }
  /**
   * @param {CreateWithText | null} [arg0]
   */
  set create_with_text(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, CreateWithText);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_linkaction_create_with_text(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {Create | undefined}
   */
  get create() {
    const ret = wasm.__wbg_get_linkaction_create(this.__wbg_ptr);
    return ret === 0 ? undefined : Create.__wrap(ret);
  }
  /**
   * @param {Create | null} [arg0]
   */
  set create(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, Create);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_linkaction_create(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {Edit | undefined}
   */
  get edit_link() {
    const ret = wasm.__wbg_get_linkaction_edit_link(this.__wbg_ptr);
    return ret === 0 ? undefined : Edit.__wrap(ret);
  }
  /**
   * @param {Edit | null} [arg0]
   */
  set edit_link(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, Edit);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_linkaction_edit_link(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {Disabled | undefined}
   */
  get disabled() {
    const ret = wasm.__wbg_get_linkaction_disabled(this.__wbg_ptr);
    return ret === 0 ? undefined : Disabled.__wrap(ret);
  }
  /**
   * @param {Disabled | null} [arg0]
   */
  set disabled(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, Disabled);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_linkaction_disabled(this.__wbg_ptr, ptr0);
  }
}
exports.LinkAction = LinkAction;
const MenuActionFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_menuaction_free(ptr >>> 0, 1));
class MenuAction {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(MenuAction.prototype);
    obj.__wbg_ptr = ptr;
    MenuActionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    MenuActionFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_menuaction_free(ptr, 0);
  }
  /**
   * @returns {boolean}
   */
  keep() {
    const ret = wasm.menuaction_keep(this.__wbg_ptr);
    return ret !== 0;
  }
  /**
   * @returns {boolean}
   */
  none() {
    const ret = wasm.menuaction_none(this.__wbg_ptr);
    return ret !== 0;
  }
  /**
   * @returns {MenuActionSuggestion | undefined}
   */
  suggestion() {
    const ret = wasm.menuaction_suggestion(this.__wbg_ptr);
    return ret === 0 ? undefined : MenuActionSuggestion.__wrap(ret);
  }
}
exports.MenuAction = MenuAction;
const MenuActionSuggestionFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_menuactionsuggestion_free(ptr >>> 0, 1));
class MenuActionSuggestion {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(MenuActionSuggestion.prototype);
    obj.__wbg_ptr = ptr;
    MenuActionSuggestionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    MenuActionSuggestionFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_menuactionsuggestion_free(ptr, 0);
  }
  /**
   * @returns {SuggestionPattern}
   */
  get suggestion_pattern() {
    const ret = wasm.__wbg_get_menuactionsuggestion_suggestion_pattern(this.__wbg_ptr);
    return SuggestionPattern.__wrap(ret);
  }
  /**
   * @param {SuggestionPattern} arg0
   */
  set suggestion_pattern(arg0) {
    _assertClass(arg0, SuggestionPattern);
    var ptr0 = arg0.__destroy_into_raw();
    wasm.__wbg_set_menuactionsuggestion_suggestion_pattern(this.__wbg_ptr, ptr0);
  }
}
exports.MenuActionSuggestion = MenuActionSuggestion;
const MenuStateFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_menustate_free(ptr >>> 0, 1));
class MenuState {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(MenuState.prototype);
    obj.__wbg_ptr = ptr;
    MenuStateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    MenuStateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_menustate_free(ptr, 0);
  }
  /**
   * @returns {boolean}
   */
  keep() {
    const ret = wasm.menustate_keep(this.__wbg_ptr);
    return ret !== 0;
  }
  /**
   * @returns {MenuStateUpdate | undefined}
   */
  update() {
    const ret = wasm.menustate_update(this.__wbg_ptr);
    return ret === 0 ? undefined : MenuStateUpdate.__wrap(ret);
  }
}
exports.MenuState = MenuState;
const MenuStateUpdateFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_menustateupdate_free(ptr >>> 0, 1));
class MenuStateUpdate {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(MenuStateUpdate.prototype);
    obj.__wbg_ptr = ptr;
    MenuStateUpdateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    MenuStateUpdateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_menustateupdate_free(ptr, 0);
  }
  /**
   * @returns {Map<any, any>}
   */
  get action_states() {
    const ret = wasm.__wbg_get_menustateupdate_action_states(this.__wbg_ptr);
    return ret;
  }
  /**
   * @param {Map<any, any>} arg0
   */
  set action_states(arg0) {
    wasm.__wbg_set_menustateupdate_action_states(this.__wbg_ptr, arg0);
  }
}
exports.MenuStateUpdate = MenuStateUpdate;
const PatternKeyFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_patternkey_free(ptr >>> 0, 1));
class PatternKey {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(PatternKey.prototype);
    obj.__wbg_ptr = ptr;
    PatternKeyFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    PatternKeyFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_patternkey_free(ptr, 0);
  }
  /**
   * @returns {PatternKeyType}
   */
  get key_type() {
    const ret = wasm.__wbg_get_patternkey_key_type(this.__wbg_ptr);
    return ret;
  }
  /**
   * @param {PatternKeyType} arg0
   */
  set key_type(arg0) {
    wasm.__wbg_set_patternkey_key_type(this.__wbg_ptr, arg0);
  }
  /**
   * @returns {string | undefined}
   */
  get custom_key_value() {
    const ret = wasm.__wbg_get_patternkey_custom_key_value(this.__wbg_ptr);
    let v1;
    if (ret[0] !== 0) {
      v1 = getStringFromWasm0(ret[0], ret[1]).slice();
      wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
    }
    return v1;
  }
  /**
   * @param {string | null} [arg0]
   */
  set custom_key_value(arg0) {
    var ptr0 = isLikeNone(arg0) ? 0 : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_patternkey_custom_key_value(this.__wbg_ptr, ptr0, len0);
  }
}
exports.PatternKey = PatternKey;
const ReplaceAllFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_replaceall_free(ptr >>> 0, 1));
class ReplaceAll {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(ReplaceAll.prototype);
    obj.__wbg_ptr = ptr;
    ReplaceAllFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    ReplaceAllFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_replaceall_free(ptr, 0);
  }
  /**
   * @returns {string}
   */
  get replacement_html() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.__wbg_get_replaceall_replacement_html(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @param {string} arg0
   */
  set replacement_html(arg0) {
    const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_edit_url(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {number}
   */
  get start_utf16_codeunit() {
    const ret = wasm.__wbg_get_replaceall_start_utf16_codeunit(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set start_utf16_codeunit(arg0) {
    wasm.__wbg_set_replaceall_start_utf16_codeunit(this.__wbg_ptr, arg0);
  }
  /**
   * @returns {number}
   */
  get end_utf16_codeunit() {
    const ret = wasm.__wbg_get_replaceall_end_utf16_codeunit(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set end_utf16_codeunit(arg0) {
    wasm.__wbg_set_replaceall_end_utf16_codeunit(this.__wbg_ptr, arg0);
  }
}
exports.ReplaceAll = ReplaceAll;
const SelectionFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_selection_free(ptr >>> 0, 1));
class Selection {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(Selection.prototype);
    obj.__wbg_ptr = ptr;
    SelectionFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    SelectionFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_selection_free(ptr, 0);
  }
  /**
   * @returns {number}
   */
  get start_utf16_codeunit() {
    const ret = wasm.__wbg_get_selection_start_utf16_codeunit(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set start_utf16_codeunit(arg0) {
    wasm.__wbg_set_selection_start_utf16_codeunit(this.__wbg_ptr, arg0);
  }
  /**
   * @returns {number}
   */
  get end_utf16_codeunit() {
    const ret = wasm.__wbg_get_selection_end_utf16_codeunit(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set end_utf16_codeunit(arg0) {
    wasm.__wbg_set_selection_end_utf16_codeunit(this.__wbg_ptr, arg0);
  }
}
exports.Selection = Selection;
const SuggestionPatternFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_suggestionpattern_free(ptr >>> 0, 1));
class SuggestionPattern {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(SuggestionPattern.prototype);
    obj.__wbg_ptr = ptr;
    SuggestionPatternFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    SuggestionPatternFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_suggestionpattern_free(ptr, 0);
  }
  /**
   * @returns {PatternKey}
   */
  get key() {
    const ret = wasm.__wbg_get_suggestionpattern_key(this.__wbg_ptr);
    return PatternKey.__wrap(ret);
  }
  /**
   * @param {PatternKey} arg0
   */
  set key(arg0) {
    _assertClass(arg0, PatternKey);
    var ptr0 = arg0.__destroy_into_raw();
    wasm.__wbg_set_suggestionpattern_key(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {string}
   */
  get text() {
    let deferred1_0;
    let deferred1_1;
    try {
      const ret = wasm.__wbg_get_suggestionpattern_text(this.__wbg_ptr);
      deferred1_0 = ret[0];
      deferred1_1 = ret[1];
      return getStringFromWasm0(ret[0], ret[1]);
    } finally {
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @param {string} arg0
   */
  set text(arg0) {
    const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    wasm.__wbg_set_edit_url(this.__wbg_ptr, ptr0, len0);
  }
  /**
   * @returns {number}
   */
  get start() {
    const ret = wasm.__wbg_get_suggestionpattern_start(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set start(arg0) {
    wasm.__wbg_set_suggestionpattern_start(this.__wbg_ptr, arg0);
  }
  /**
   * @returns {number}
   */
  get end() {
    const ret = wasm.__wbg_get_suggestionpattern_end(this.__wbg_ptr);
    return ret >>> 0;
  }
  /**
   * @param {number} arg0
   */
  set end(arg0) {
    wasm.__wbg_set_suggestionpattern_end(this.__wbg_ptr, arg0);
  }
}
exports.SuggestionPattern = SuggestionPattern;
const TextUpdateFinalization = typeof FinalizationRegistry === 'undefined' ? {
  register: () => {},
  unregister: () => {}
} : new FinalizationRegistry(ptr => wasm.__wbg_textupdate_free(ptr >>> 0, 1));
class TextUpdate {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(TextUpdate.prototype);
    obj.__wbg_ptr = ptr;
    TextUpdateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    TextUpdateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_textupdate_free(ptr, 0);
  }
  /**
   * @returns {Keep | undefined}
   */
  get keep() {
    const ret = wasm.__wbg_get_textupdate_keep(this.__wbg_ptr);
    return ret === 0 ? undefined : Keep.__wrap(ret);
  }
  /**
   * @param {Keep | null} [arg0]
   */
  set keep(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, Keep);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_textupdate_keep(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {ReplaceAll | undefined}
   */
  get replace_all() {
    const ret = wasm.__wbg_get_textupdate_replace_all(this.__wbg_ptr);
    return ret === 0 ? undefined : ReplaceAll.__wrap(ret);
  }
  /**
   * @param {ReplaceAll | null} [arg0]
   */
  set replace_all(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, ReplaceAll);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_textupdate_replace_all(this.__wbg_ptr, ptr0);
  }
  /**
   * @returns {Selection | undefined}
   */
  get select() {
    const ret = wasm.__wbg_get_textupdate_select(this.__wbg_ptr);
    return ret === 0 ? undefined : Selection.__wrap(ret);
  }
  /**
   * @param {Selection | null} [arg0]
   */
  set select(arg0) {
    let ptr0 = 0;
    if (!isLikeNone(arg0)) {
      _assertClass(arg0, Selection);
      ptr0 = arg0.__destroy_into_raw();
    }
    wasm.__wbg_set_textupdate_select(this.__wbg_ptr, ptr0);
  }
}
exports.TextUpdate = TextUpdate;
function __wbg_body_942ea927546a04ba(arg0) {
  const ret = arg0.body;
  return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
}
;
function __wbg_childNodes_c4423003f3a9441f(arg0) {
  const ret = arg0.childNodes;
  return ret;
}
;
function __wbg_error_7534b8e9a36f1ab4(arg0, arg1) {
  let deferred0_0;
  let deferred0_1;
  try {
    deferred0_0 = arg0;
    deferred0_1 = arg1;
    console.error(getStringFromWasm0(arg0, arg1));
  } finally {
    wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
  }
}
;
function __wbg_forEach_d6a05ca96422eff9(arg0, arg1, arg2) {
  try {
    var state0 = {
      a: arg1,
      b: arg2
    };
    var cb0 = (arg0, arg1, arg2) => {
      const a = state0.a;
      state0.a = 0;
      try {
        return __wbg_adapter_124(a, state0.b, arg0, arg1, arg2);
      } finally {
        state0.a = a;
      }
    };
    arg0.forEach(cb0);
  } finally {
    state0.a = state0.b = 0;
  }
}
;
function __wbg_forEach_e1cf6f7c8ecb7dae(arg0, arg1, arg2) {
  try {
    var state0 = {
      a: arg1,
      b: arg2
    };
    var cb0 = (arg0, arg1) => {
      const a = state0.a;
      state0.a = 0;
      try {
        return __wbg_adapter_127(a, state0.b, arg0, arg1);
      } finally {
        state0.a = a;
      }
    };
    arg0.forEach(cb0);
  } finally {
    state0.a = state0.b = 0;
  }
}
;
function __wbg_getAttribute_ea5166be2deba45e(arg0, arg1, arg2, arg3) {
  const ret = arg1.getAttribute(getStringFromWasm0(arg2, arg3));
  var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  var len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}
;
function __wbg_getPropertyValue_e623c23a05dfb30c() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    const ret = arg1.getPropertyValue(getStringFromWasm0(arg2, arg3));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  }, arguments);
}
;
function __wbg_get_e27dfaeb6f46bd45(arg0, arg1) {
  const ret = arg0[arg1 >>> 0];
  return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
}
;
function __wbg_hasAttribute_db31090c2e646f57(arg0, arg1, arg2) {
  const ret = arg0.hasAttribute(getStringFromWasm0(arg1, arg2));
  return ret;
}
;
function __wbg_length_49b2ba67f0897e97(arg0) {
  const ret = arg0.length;
  return ret;
}
;
function __wbg_new_363ae9575a2aba54() {
  return handleError(function () {
    const ret = new DOMParser();
    return ret;
  }, arguments);
}
;
function __wbg_new_5e0be73521bc8c17() {
  const ret = new Map();
  return ret;
}
;
function __wbg_new_8a6f238a6ece86ea() {
  const ret = new Error();
  return ret;
}
;
function __wbg_nodeName_ff3aa439a5af6311(arg0, arg1) {
  const ret = arg1.nodeName;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}
;
function __wbg_nodeType_5e1153141daac26a(arg0) {
  const ret = arg0.nodeType;
  return ret;
}
;
function __wbg_nodeValue_6ff4f14870c43bd9(arg0, arg1) {
  const ret = arg1.nodeValue;
  var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  var len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}
;
function __wbg_parseFromString_91cbec9ba27a222a() {
  return handleError(function (arg0, arg1, arg2, arg3) {
    const ret = arg0.parseFromString(getStringFromWasm0(arg1, arg2), __wbindgen_enum_SupportedType[arg3]);
    return ret;
  }, arguments);
}
;
function __wbg_set_8fc6bf8a5b1071d1(arg0, arg1, arg2) {
  const ret = arg0.set(arg1, arg2);
  return ret;
}
;
function __wbg_stack_0ed75d68575b0f3c(arg0, arg1) {
  const ret = arg1.stack;
  const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  const len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}
;
function __wbg_style_fb30c14e5815805c(arg0) {
  const ret = arg0.style;
  return ret;
}
;
function __wbindgen_init_externref_table() {
  const table = wasm.__wbindgen_export_1;
  const offset = table.grow(4);
  table.set(0, undefined);
  table.set(offset + 0, undefined);
  table.set(offset + 1, null);
  table.set(offset + 2, true);
  table.set(offset + 3, false);
  ;
}
;
function __wbindgen_number_new(arg0) {
  const ret = arg0;
  return ret;
}
;
function __wbindgen_string_get(arg0, arg1) {
  const obj = arg1;
  const ret = typeof obj === 'string' ? obj : undefined;
  var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
  var len1 = WASM_VECTOR_LEN;
  getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
  getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
}
;
function __wbindgen_string_new(arg0, arg1) {
  const ret = getStringFromWasm0(arg0, arg1);
  return ret;
}
;
function __wbindgen_throw(arg0, arg1) {
  throw new Error(getStringFromWasm0(arg0, arg1));
}
;