/* tslint:disable */
/* eslint-disable */
export function start(): void;
export function new_composer_model(): ComposerModel;
export function new_composer_model_from_html(html: string, start_utf16_codeunit: number, end_utf16_codeunit: number): ComposerModel;
export enum ActionState {
  /**
   * The button can be clicked, and will perform its normal action
   * e.g. make something bold
   */
  Enabled = 0,
  /**
   * The button can be clicked, and will perform the reverse of its
   * normal action e.g. stop something being bold
   */
  Reversed = 1,
  /**
   * The button cannot be clicked
   */
  Disabled = 2,
}
export enum ComposerAction {
  Bold = 0,
  Italic = 1,
  StrikeThrough = 2,
  Underline = 3,
  InlineCode = 4,
  Link = 5,
  Undo = 6,
  Redo = 7,
  OrderedList = 8,
  UnorderedList = 9,
  Indent = 10,
  Unindent = 11,
  CodeBlock = 12,
  Quote = 13,
}
export enum DomCreationError {
  HtmlParseError = 0,
  MarkdownParseError = 1,
}
export enum HtmlSource {
  Matrix = 0,
  GoogleDoc = 1,
  UnknownExternal = 2,
}
export enum PatternKeyType {
  At = 0,
  Hash = 1,
  Slash = 2,
  Custom = 3,
  Colon = 4,
}
export class ComposerModel {
  private constructor();
  free(): void;
  static new(): ComposerModel;
  static from_example_format(text: string): ComposerModel;
  to_example_format(): string;
  get_content_as_html(): string;
  get_content_as_message_html(): string;
  get_content_as_markdown(): string;
  get_content_as_message_markdown(): string;
  get_content_as_plain_text(): string;
  document(): DomHandle;
  action_states(): Map<any, any>;
  select(start_utf16_codeunit: number, end_utf16_codeunit: number): ComposerUpdate;
  selection_start(): number;
  selection_end(): number;
  replace_text(new_text: string): ComposerUpdate;
  replace_html(new_html: string, external_source: HtmlSource): ComposerUpdate;
  replace_text_suggestion(new_text: string, suggestion: SuggestionPattern, append_space: boolean): ComposerUpdate;
  set_content_from_html(text: string): ComposerUpdate;
  set_content_from_markdown(text: string): ComposerUpdate;
  clear(): ComposerUpdate;
  enter(): ComposerUpdate;
  backspace(): ComposerUpdate;
  backspace_word(): ComposerUpdate;
  delete(): ComposerUpdate;
  delete_word(): ComposerUpdate;
  bold(): ComposerUpdate;
  italic(): ComposerUpdate;
  strike_through(): ComposerUpdate;
  underline(): ComposerUpdate;
  quote(): ComposerUpdate;
  inline_code(): ComposerUpdate;
  code_block(): ComposerUpdate;
  undo(): ComposerUpdate;
  redo(): ComposerUpdate;
  ordered_list(): ComposerUpdate;
  unordered_list(): ComposerUpdate;
  indent(): ComposerUpdate;
  unindent(): ComposerUpdate;
  get_link_action(): LinkAction;
  set_link(url: string, attributes: Map<any, any>): ComposerUpdate;
  set_link_with_text(url: string, text: string, attributes: Map<any, any>): ComposerUpdate;
  set_custom_suggestion_patterns(custom_suggestion_patterns: Array<any>): void;
  /**
   * Creates an at-room mention node and inserts it into the composer at the current selection
   */
  insert_at_room_mention(attributes: Map<any, any>): ComposerUpdate;
  /**
   * Creates a mention node and inserts it into the composer at the current selection
   */
  insert_mention(url: string, text: string, attributes: Map<any, any>): ComposerUpdate;
  /**
   * Creates an at-room mention node and inserts it into the composer, replacing the
   * text content defined by the suggestion
   */
  insert_at_room_mention_at_suggestion(suggestion: SuggestionPattern, attributes: Map<any, any>): ComposerUpdate;
  /**
   * Creates a mention node and inserts it into the composer, replacing the
   * text content defined by the suggestion
   */
  insert_mention_at_suggestion(url: string, text: string, suggestion: SuggestionPattern, attributes: Map<any, any>): ComposerUpdate;
  remove_links(): ComposerUpdate;
}
export class ComposerUpdate {
  private constructor();
  free(): void;
  text_update(): TextUpdate;
  menu_state(): MenuState;
  menu_action(): MenuAction;
}
export class Create {
  private constructor();
  free(): void;
}
export class CreateWithText {
  private constructor();
  free(): void;
}
export class Disabled {
  private constructor();
  free(): void;
}
/**
 * An iterator-like view of a DomHandle's children, written to work around
 * the lack of support for returning Vec<T> in wasm_bindgen.
 */
export class DomChildren {
  private constructor();
  free(): void;
  next_child(): DomHandle | undefined;
}
/**
 * Refers to a node in the composer model.
 */
export class DomHandle {
  private constructor();
  free(): void;
  /**
   * Returns "container", "line_break", "text" or "zwsp" depending on the type of
   * node we refer to.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   */
  node_type(model: ComposerModel): string;
  /**
   * Returns a list of our children nodes, or an empty list if we refer
   * to a text or line break node.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   */
  children(model: ComposerModel): DomChildren;
  /**
   * Returns the text of this node, or an empty string if this is a
   * container or line break.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   */
  text(model: ComposerModel): string;
  /**
   * Returns our tagname, or "-text-"/"-zwsp-" if we are a text/zwsp node.
   * Panics if we are not a valid reference (because the model has changed
   * since we were created, or because you passed in a different model
   * from the one that created us.)
   */
  tag(model: ComposerModel): string;
}
export class Edit {
  private constructor();
  free(): void;
  url: string;
}
export class Keep {
  private constructor();
  free(): void;
}
export class LinkAction {
  private constructor();
  free(): void;
  get create_with_text(): CreateWithText | undefined;
  set create_with_text(value: CreateWithText | null | undefined);
  get create(): Create | undefined;
  set create(value: Create | null | undefined);
  get edit_link(): Edit | undefined;
  set edit_link(value: Edit | null | undefined);
  get disabled(): Disabled | undefined;
  set disabled(value: Disabled | null | undefined);
}
export class MenuAction {
  private constructor();
  free(): void;
  keep(): boolean;
  none(): boolean;
  suggestion(): MenuActionSuggestion | undefined;
}
export class MenuActionSuggestion {
  private constructor();
  free(): void;
  suggestion_pattern: SuggestionPattern;
}
export class MenuState {
  private constructor();
  free(): void;
  keep(): boolean;
  update(): MenuStateUpdate | undefined;
}
export class MenuStateUpdate {
  private constructor();
  free(): void;
  action_states: Map<any, any>;
}
export class PatternKey {
  private constructor();
  free(): void;
  key_type: PatternKeyType;
  get custom_key_value(): string | undefined;
  set custom_key_value(value: string | null | undefined);
}
export class ReplaceAll {
  private constructor();
  free(): void;
  replacement_html: string;
  start_utf16_codeunit: number;
  end_utf16_codeunit: number;
}
export class Selection {
  private constructor();
  free(): void;
  start_utf16_codeunit: number;
  end_utf16_codeunit: number;
}
export class SuggestionPattern {
  private constructor();
  free(): void;
  key: PatternKey;
  text: string;
  start: number;
  end: number;
}
export class TextUpdate {
  private constructor();
  free(): void;
  get keep(): Keep | undefined;
  set keep(value: Keep | null | undefined);
  get replace_all(): ReplaceAll | undefined;
  set replace_all(value: ReplaceAll | null | undefined);
  get select(): Selection | undefined;
  set select(value: Selection | null | undefined);
}
