import { useState as E, useRef as b, useEffect as h, useMemo as C, useCallback as A } from "react";
import { HtmlSource as H, initAsync as ae, new_composer_model_from_html as G, new_composer_model as w } from "@vector-im/matrix-wysiwyg-wasm";
function y(e) {
  return "inputType" in e;
}
function V(e) {
  return "clipboardData" in e;
}
function ce(e) {
  return y(e) && e.inputType === "insertSuggestion";
}
function ue(e) {
  return y(e) && e.inputType === "insertAtRoomSuggestion";
}
function le(e) {
  return y(e) && e.inputType == "insertLink";
}
function X(e, t, n, s) {
  return s ? s(e, t, n) : e;
}
function fe(e, t, n, s, r, i, c, l) {
  const a = X(
    e,
    {
      actions: s,
      content: () => t.get_content_as_html(),
      messageContent: () => t.get_content_as_message_html()
    },
    r,
    c
  );
  if (!a)
    return;
  if (V(a)) {
    const o = a.clipboardData, f = o?.getData("text/html"), m = o?.getData("text/plain") ?? "";
    if (f && f !== m) {
      const d = o?.types.includes(
        "application/x-vnd.google-docs-document-slice-clip+wrapped"
      ) ? H.GoogleDoc : H.UnknownExternal;
      return n(
        t.replace_html(f, d),
        "replace_html_paste"
      );
    }
    return n(
      t.replace_text(m),
      "replace_text_paste"
    );
  }
  switch (a.inputType) {
    case "insertAtRoomSuggestion": {
      if (i && ue(a)) {
        const { attributes: o } = a.data;
        return o.has("data-mention-type") && o.delete("data-mention-type"), n(
          t.insert_at_room_mention_at_suggestion(
            i,
            o
          ),
          "insert_at_room_mention_at_suggestion"
        );
      }
      break;
    }
    case "insertSuggestion": {
      if (i && ce(a)) {
        const { text: o, url: f, attributes: m } = a.data;
        return m.has("data-mention-type") && m.delete("data-mention-type"), n(
          t.insert_mention_at_suggestion(
            f,
            o,
            i,
            m
          ),
          "insert_mention_at_suggestion"
        );
      }
      break;
    }
    case "insertCommand":
    case "insertEmoji": {
      if (i && a.data) {
        const o = a.inputType === "insertCommand";
        return n(
          t.replace_text_suggestion(
            a.data,
            i,
            o
          ),
          "replace_text_suggestion"
        );
      }
      break;
    }
    case "clear":
      return n(t.clear(), "clear");
    case "deleteContentBackward":
      return n(t.backspace(), "backspace");
    case "deleteWordBackward":
      return n(t.backspace_word(), "backspace_word");
    case "deleteSoftLineBackward": {
      const o = document.getSelection();
      return o && (o.modify("extend", "backward", "lineboundary"), document.dispatchEvent(new CustomEvent("selectionchange"))), n(t.delete(), "backspace_line");
    }
    case "deleteContentForward":
      return n(t.delete(), "delete");
    case "deleteWordForward":
      return n(t.delete_word(), "delete_word");
    case "deleteByCut":
      return n(t.delete(), "delete");
    case "formatBold":
      return n(t.bold(), "bold");
    case "formatItalic":
      return n(t.italic(), "italic");
    case "formatStrikeThrough":
      return n(t.strike_through(), "strike_through");
    case "formatUnderline":
      return n(t.underline(), "underline");
    case "formatInlineCode":
      return n(t.inline_code(), "inline_code");
    case "historyRedo":
      return n(t.redo(), "redo");
    case "historyUndo":
      return n(t.undo(), "undo");
    case "insertCodeBlock":
      return n(t.code_block(), "code_block");
    case "insertQuote":
      return n(t.quote(), "quote");
    case "insertFromPaste":
      return;
    case "insertOrderedList":
      return n(t.ordered_list(), "ordered_list");
    case "insertLineBreak":
    case "insertParagraph":
      return u(
        t,
        i,
        l
      ), n(t.enter(), "enter");
    case "insertReplacementText": {
      const o = r.innerHTML.slice(
        0,
        r.innerHTML.length - 4
      );
      return n(
        t.set_content_from_html(o),
        "set_content_from_html",
        o
      );
    }
    case "insertCompositionText":
    case "insertFromComposition":
    case "insertText":
      if (a.data)
        return a.data == " " && u(
          t,
          i,
          l
        ), n(
          t.replace_text(a.data),
          "replace_text",
          a.data
        );
      break;
    case "insertUnorderedList":
      return n(t.unordered_list(), "unordered_list");
    case "insertLink":
      if (le(a)) {
        const { text: o, url: f } = a.data;
        return n(
          o ? t.set_link_with_text(f, o, /* @__PURE__ */ new Map()) : t.set_link(f, /* @__PURE__ */ new Map()),
          "insertLink"
        );
      }
      break;
    case "removeLinks":
      return n(t.remove_links(), "remove_links");
    case "formatIndent":
      return n(t.indent(), "indent");
    case "formatOutdent":
      return n(t.unindent(), "unindent");
    case "sendMessage":
      return null;
    default:
      return console.error(`Unknown input type: ${a.inputType}`), console.error(e), null;
  }
  function u(o, f, m) {
    if (m && f && f.key.key_type == 3 && f.key.custom_key_value) {
      const d = m.get(f.key.custom_key_value);
      d && o.replace_text_suggestion(d, f, !1);
    }
  }
}
function de(e, t) {
  e.innerHTML = "";
  const n = t.document();
  let s = 0;
  function r(c, l, a, u) {
    const o = document.createElement(l);
    if (a && (o.innerText = a.replace("​", "~")), u)
      for (const [f, m] of u.entries()) {
        const d = document.createAttribute(f);
        m !== null && (d.value = m), o.setAttributeNode(d);
      }
    return c.appendChild(o), o;
  }
  function i(c, l) {
    const a = r(l, "ul");
    a.className = `group_${s % 10}`;
    const u = c.children(t);
    let o;
    for (; o = u.next_child(); ) {
      const f = o.node_type(t);
      if (f === "container") {
        const d = `dom_${s}`;
        s++;
        const g = r(a, "li");
        r(
          g,
          "input",
          null,
          /* @__PURE__ */ new Map([
            ["type", "checkbox"],
            ["id", d],
            ["checked", null]
          ])
        ), r(
          g,
          "label",
          o.tag(t),
          /* @__PURE__ */ new Map([["for", d]])
        ), i(o, g);
      } else if (f === "line_break")
        r(a, "li", "br");
      else if (f === "text") {
        const m = r(a, "li");
        r(m, "span", '"', /* @__PURE__ */ new Map([["class", "quote"]])), r(m, "span", `${o.text(t)}`), r(m, "span", '"', /* @__PURE__ */ new Map([["class", "quote"]]));
      } else if (f === "mention") {
        const m = r(a, "li");
        r(
          m,
          "span",
          '"Mention - ',
          /* @__PURE__ */ new Map([["class", "quote"]])
        ), r(m, "span", `${o.text(t)}`), r(m, "span", '"', /* @__PURE__ */ new Map([["class", "quote"]]));
      } else
        console.error(`Unknown node type: ${f}`);
    }
  }
  i(n, e);
}
function me(e, t, n) {
  const s = document.createRange();
  let r = I(e, t), i = I(e, n);
  if (r.node && i.node) {
    const l = r.node.compareDocumentPosition(i.node) & Node.DOCUMENT_POSITION_PRECEDING, a = r.node === i.node && i.offset < r.offset;
    if ((l || a) && ([r, i] = [i, r], !r.node || !i.node))
      throw new Error();
    s.setStart(r.node, r.offset), s.setEnd(i.node, i.offset);
  } else
    s.selectNodeContents(e), s.collapse();
  const c = document.getSelection();
  c && (c.removeAllRanges(), c.addRange(s));
}
function z(e, t, n, s) {
  e.innerHTML = t + "<br />", me(e, n, s);
}
function I(e, t, n) {
  const s = e.nodeName === "LI" && !e.hasChildNodes(), r = e.nodeType === Node.TEXT_NODE;
  if (r && e.parentElement?.hasAttribute("data-mention-type")) {
    const l = L(e) ? 1 : 0, a = t - l;
    return a <= 1 ? a === 0 ? e.previousSibling ? {
      node: e.previousSibling,
      offset: T(
        e.previousSibling,
        1 / 0
      )
    } : {
      node: e.parentNode?.parentNode ?? null,
      offset: 0
    } : { node: null, offset: 0 } : { node: null, offset: t - l - 1 };
  } else if (r) {
    const l = L(e) ? 1 : 0;
    return Z(e) ? t === 0 ? { node: e, offset: t } : { node: null, offset: t - l } : t <= (e.textContent?.length || 0) ? { node: e, offset: t } : {
      node: null,
      offset: t - (e.textContent?.length || 0) - l
    };
  } else {
    if (s)
      return t <= (e.textContent?.length || 0) ? { node: e, offset: t } : {
        node: null,
        offset: t - (e.textContent?.length || 0)
      };
    if (e.nodeName === "BR")
      return t === 0 ? { node: e, offset: 0 } : {
        node: null,
        offset: t - 1
      };
    if (ge(e) && t === 0)
      return { node: e, offset: t };
    for (const c of e.childNodes) {
      const l = I(
        c,
        t
      );
      if (l.node)
        return { node: l.node, offset: l.offset };
      t = l.offset;
    }
    return { node: null, offset: t };
  }
}
function Q(e, t) {
  const n = e.childNodes.length === 1 && e.firstChild?.nodeName === "BR";
  if (!t || n)
    return [0, 0];
  const s = t.anchorNode && F(
    e,
    t.anchorNode,
    t.anchorOffset
  ) || 0, r = t.focusNode && F(
    e,
    t.focusNode,
    t.focusOffset
  ) || 0;
  return [s, r];
}
function T(e, t) {
  if (e.nodeType === Node.TEXT_NODE) {
    const s = L(e) ? 1 : 0;
    return (e.textContent?.length ?? 0) + s;
  } else {
    if (e.nodeName === "BR")
      return t === 0 ? 0 : 1;
    {
      let n = 0, s = 0;
      for (const r of e.childNodes) {
        if (s === t)
          break;
        n += T(r, -1), s++;
      }
      return n;
    }
  }
}
function Y(e, t, n) {
  const s = e.nodeType === Node.TEXT_NODE, r = e.parentElement?.hasAttribute("data-mention-type");
  if (e === t)
    return s ? n > (e.textContent?.length ?? 0) ? { found: !1, offset: 0 } : r ? { found: !0, offset: n === 0 ? 0 : 1 } : { found: !0, offset: n } : { found: !0, offset: T(e, n) };
  if (s) {
    const c = L(e) ? 1 : 0;
    return Z(e) ? { found: !1, offset: c } : r ? { found: !1, offset: 1 + c } : {
      found: !1,
      offset: (e.textContent?.length ?? 0) + c
    };
  } else {
    if (e.nodeName === "BR")
      return { found: !1, offset: 1 };
    {
      let i = 0;
      for (const c of e.childNodes) {
        const l = Y(c, t, n);
        if (l.found)
          return { found: !0, offset: i + l.offset };
        i += l.offset;
      }
      return { found: !1, offset: i };
    }
  }
}
function F(e, t, n) {
  if (t === e && n === e.childNodes.length - 1)
    return T(e, -1) - 1;
  const s = new Range();
  s.setStart(e, 0), s.setEnd(e, e.childNodes.length);
  const r = s.comparePoint(t, 0);
  if (r === -1)
    return 0;
  if (r === 1)
    return T(e, -1) - 1;
  const i = Y(e, t, n);
  return i.found ? i.offset : -1;
}
function L(e) {
  if (e === null) return !1;
  let t = e;
  const n = P(t.parentNode);
  for (; t; ) {
    const s = t.nextSibling;
    if (s && P(s) || n && s && !K(s) || s && s.nodeName === "BR")
      break;
    if (K(t))
      return !0;
    t = t.parentNode;
  }
  return !1;
}
const J = ["EM", "U", "STRONG", "DEL", "CODE", "A"], _e = ["OL", "UL", "LI", "PRE", "BLOCKQUOTE", "P"];
function P(e) {
  return e === null ? !1 : J.includes(e.nodeName || "");
}
function K(e) {
  return _e.includes(e.nodeName || "");
}
function ge(e) {
  return J.includes(e.nodeName) && e.textContent?.length === 0;
}
function Z(e) {
  const t = e.parentNode?.childNodes.length === 1, n = e.parentNode?.nodeName === "P", s = e.textContent === " ";
  return n && t && s;
}
const pe = [
  "bold",
  "italic",
  "strikeThrough",
  "underline",
  "undo",
  "redo",
  "orderedList",
  "unorderedList",
  "inlineCode",
  "clear",
  "link",
  "codeBlock",
  "quote",
  "indent",
  "unindent"
], he = ["@", "#", "/", "", ":"];
function ye() {
  return pe.reduce((e, t) => (e[t] = "enabled", e), {});
}
function M(e) {
  const t = {};
  for (const [n, s] of e)
    t[n.substring(0, 1).toLowerCase() + n.substring(1)] = s.toLowerCase();
  return t;
}
function Ee() {
  const e = navigator.userAgent.toLowerCase();
  return e.includes("iphone") || e.includes("ipad") ? "iOS" : e.includes("android") ? "Android" : e.includes("win") ? "Windows" : e.includes("mac") ? "macOS" : e.includes("linux") ? "Linux" : null;
}
function ee(e, t, n, s) {
  n?.preventDefault(), n?.stopPropagation(), e.dispatchEvent(
    new CustomEvent("wysiwygInput", { detail: { blockType: t, data: s } })
  );
}
function ke(e, t, n, s, r) {
  if (e.shiftKey && e.altKey)
    switch (e.key) {
      case "5":
        return "formatStrikeThrough";
    }
  const i = Ee();
  if ((i === "Windows" || i === "Linux") && e.ctrlKey)
    switch (e.key) {
      case "Backspace":
        return "deleteWordBackward";
    }
  if (e.ctrlKey || e.metaKey)
    switch (e.key) {
      case "b":
        return "formatBold";
      case "i":
        return "formatItalic";
      case "u":
        return "formatUnderline";
      case "e":
        return "formatInlineCode";
      case "y":
        return "historyRedo";
      case "z":
        return "historyUndo";
      case "Z":
        return "historyRedo";
      case "Enter":
        return "sendMessage";
      case "Backspace":
        return "deleteSoftLineBackward";
    }
  return X(
    e,
    {
      actions: n,
      content: () => t.get_content_as_html(),
      messageContent: () => t.get_content_as_message_html()
    },
    s,
    r
  ), null;
}
function xe(e, t, n, s, r) {
  const i = ke(
    e,
    n,
    s,
    t,
    r
  );
  i && ee(t, i, e);
}
function te(e) {
  return M(e.action_states);
}
function Ce(e, t, n, s, r, i, c, l, a) {
  const u = fe(
    e,
    n,
    r.traceAction,
    i,
    t,
    c,
    l,
    a
  );
  if (u) {
    const o = u.text_update().replace_all;
    o && (z(
      t,
      o.replacement_html,
      o.start_utf16_codeunit,
      o.end_utf16_codeunit
    ), r.setEditorHtml(o.replacement_html)), t.focus(), s && de(s, n);
    const f = u.menu_state().update(), m = u.menu_action().suggestion()?.suggestion_pattern, d = f ? te(f) : null, g = m || null;
    return {
      content: o?.replacement_html,
      actionStates: d,
      suggestion: g
    };
  }
}
function Te(e, t, { traceAction: n, getSelectionAccordingToActions: s }) {
  const [r, i] = Q(e, document.getSelection()), c = t.selection_start(), l = t.selection_end(), [a, u] = s();
  if (r === c && r === a && i === l && i === u || r === l && r === u && i === c && i === a)
    return;
  const o = t.select(r, i);
  n(null, "select", r, i);
  const f = o.menu_state().update();
  if (f)
    return te(f);
}
function Se(e, t, n, s, r, i, c, l) {
  const [a, u] = E({
    content: null,
    actionStates: ye(),
    suggestion: null
  }), o = b(void 0), [f, m] = E(!1);
  return h(() => {
    n && (u({
      content: n.get_content_as_html(),
      actionStates: M(
        n.action_states()
      ),
      suggestion: null
    }), o.current = n.get_content_as_plain_text());
  }, [n]), h(() => {
    const d = e.current;
    if (!n || !d)
      return;
    const g = (_) => {
      try {
        const p = Ce(
          _,
          d,
          n,
          t.current,
          s,
          r,
          a.suggestion,
          c,
          l
        );
        p && (u((k) => {
          const re = p.content !== void 0 ? p.content : k.content, ie = p.actionStates || k.actionStates, oe = p.suggestion;
          return {
            content: re,
            actionStates: ie,
            suggestion: oe
          };
        }), o.current = n.get_content_as_plain_text());
      } catch {
        i(o.current);
      }
    }, S = (_) => {
      y(_) && !_.isComposing && g(_);
    };
    d.addEventListener("input", S);
    const v = (_) => {
      const p = y(_) && _.inputType === "insertFromPaste" && _.dataTransfer !== null;
      (V(_) || p) && (_.preventDefault(), _.stopPropagation(), g(_));
    };
    d.addEventListener("paste", v);
    const R = (_) => {
      g({
        inputType: _.detail.blockType,
        data: _.detail.data
      });
    };
    d.addEventListener("wysiwygInput", R);
    const B = (_) => {
      xe(
        _,
        d,
        n,
        r,
        c
      );
    };
    d.addEventListener("keydown", B);
    const D = () => {
      try {
        const _ = Te(
          d,
          n,
          s
        );
        _ && u(({ content: p, suggestion: k }) => ({
          content: p,
          actionStates: _,
          suggestion: k
        })), o.current = n.get_content_as_plain_text();
      } catch {
        i(o.current);
      }
    };
    document.addEventListener("selectionchange", D);
    const $ = (_) => {
      if (!(y(_) && _.isComposing))
        return v(_);
    };
    d.addEventListener("beforeinput", $);
    const U = (_) => {
      const p = new InputEvent("input", {
        data: _.data,
        inputType: "insertCompositionText"
      });
      S(p);
    };
    return d.addEventListener("compositionend", U), m(!0), () => {
      m(!1), d.removeEventListener("input", S), d.removeEventListener("paste", v), d.removeEventListener("wysiwygInput", R), d.removeEventListener("keydown", B), d.removeEventListener("beforeinput", $), d.removeEventListener("compositionend", U), document.removeEventListener("selectionchange", D);
    };
  }, [
    e,
    l,
    n,
    r,
    t,
    s,
    c,
    i,
    o,
    a.suggestion
  ]), { areListenersReady: f, ...a };
}
function we(e, t) {
  return C(() => {
    const s = (r, i) => {
      e.current && ee(
        e.current,
        r,
        void 0,
        i
      );
    };
    return {
      bold: () => s("formatBold"),
      italic: () => s("formatItalic"),
      strikeThrough: () => s("formatStrikeThrough"),
      underline: () => s("formatUnderline"),
      undo: () => s("historyUndo"),
      redo: () => s("historyRedo"),
      orderedList: () => s("insertOrderedList"),
      unorderedList: () => s("insertUnorderedList"),
      inlineCode: () => s("formatInlineCode"),
      clear: () => s("clear"),
      insertText: (r) => s("insertText", r),
      link: (r, i) => s("insertLink", { url: r, text: i }),
      removeLinks: () => s("removeLinks"),
      getLink: () => t?.get_link_action()?.edit_link?.url || "",
      codeBlock: () => s("insertCodeBlock"),
      quote: () => s("insertQuote"),
      indent: () => s("formatIndent"),
      unindent: () => s("formatOutdent"),
      mention: (r, i, c) => s("insertSuggestion", { url: r, text: i, attributes: c }),
      command: (r) => s("insertCommand", r),
      emoji: (r) => s("insertEmoji", r),
      mentionAtRoom: (r) => s("insertAtRoomSuggestion", { attributes: r })
    };
  }, [e, t]);
}
let W = !1, N = !1;
async function O() {
  if (N)
    return Promise.resolve();
  if (W)
    return new Promise((e) => {
      function t() {
        N && e(), setTimeout(t, 200);
      }
      t();
    });
  W = !0, await ae(), N = !0;
}
function Le(e, t, n) {
  const [s, r] = E(
    null
  ), i = A(
    async (c) => {
      await O();
      let l;
      if (c)
        try {
          const a = G(
            c,
            0,
            c.length
          );
          if (l = a, e.current) {
            const u = a.get_content_as_html();
            z(
              e.current,
              u,
              0,
              u.length
            );
          }
        } catch {
          l = w();
        }
      else
        l = w();
      r(l);
    },
    [r, e]
  );
  return h(() => {
    s && n && s.set_custom_suggestion_patterns(
      n
    );
  }, [s, n]), h(() => {
    e.current && i(t);
  }, [e, i, t]), { composerModel: s, onError: i };
}
function ne(e) {
  return e[0] === "select";
}
function be(e, t, n) {
  return (s, r, i, c) => (!e || !n || (console.debug(c !== void 0 ? `composer_model.${r}(${i}, ${c})` : i !== void 0 ? `composer_model.${r}(${i})` : `composer_model.${r}()`), t.push([r, i, c]), se(e, n, s, t)), s);
}
function ve(e) {
  return () => {
    for (let t = e.length - 1; t >= 0; t--) {
      const n = e[t];
      if (ne(n))
        return [n[1], n[2]];
    }
    return [-1, -1];
  };
}
function se(e, t, n, s) {
  n && n.text_update(), e.innerText = Ne(
    s,
    t.to_example_format()
  ), e.scrollTo(0, e.scrollHeight - e.clientHeight);
}
function Ne(e, t) {
  let n = "";
  function s(u, o, f) {
    u === "select" ? n += `model.select(Location::from(${o}), Location::from(${f}));
` : f !== void 0 ? n += `model.${u}(${o ?? ""}, ${f});
` : u === "replace_text" ? n += `model.${u}("${o ?? ""}");
` : u === "send" ? n += `// Send: ${o ?? ""}
` : n += `model.${u}(${o ?? ""});
`;
  }
  function r() {
    const u = Ae(l, a[0], a[1]);
    n += `let mut model = cm("${u}");
`;
  }
  let i = null, c = !0, l = "", a = [0, 0];
  for (const u of e) {
    const [o, f, m] = u;
    if (c)
      o === "replace_text" ? l += Oe(f) : ne(u) ? a = [u[1], u[2]] : (c = !1, r(), s(o, f, m));
    else if (i === "select" && o === "select") {
      const d = n.lastIndexOf(`
`, n.length - 2);
      d > -1 && (n = n.substring(0, d) + `
`, s(o, f, m));
    } else
      s(o, f, m);
    i = o;
  }
  return c && r(), n += `assert_eq!(tx(&model), "${t}");
`, n;
}
function Ae(e, t, n) {
  const s = G(e, -1, -1);
  return s.select(t, n), s.to_example_format();
}
function Ie(e, t, n, s) {
  const [r, i] = Q(e, document.getSelection()), c = [
    ["replace_text", s],
    ["select", r, i]
  ];
  return se(t, n, null, c), c;
}
function Oe(e) {
  if (!e)
    return "";
  const t = document.createElement("p");
  return t.appendChild(document.createTextNode(e.toString())), t.innerHTML;
}
function Re(e, t) {
  const n = b(null), [s, r] = E([]), [i, c] = E(""), l = A(
    (m) => {
      n.current && c(m);
    },
    [n]
  ), a = C(
    () => be(n.current, s, t),
    [n, s, t]
  ), u = C(
    () => ve(s),
    [s]
  ), o = A(
    () => e.current && n.current && t && r(
      Ie(
        e.current,
        n.current,
        t,
        i
      )
    ),
    [e, n, t, i]
  ), f = C(
    () => ({
      traceAction: a,
      getSelectionAccordingToActions: u,
      onResetTestCase: o,
      setEditorHtml: l
    }),
    [
      a,
      u,
      o,
      l
    ]
  );
  return {
    testRef: n,
    utilities: f
  };
}
function Be(e) {
  return he[e.key.key_type] || "";
}
function De(e) {
  switch (e.key.key_type) {
    case 0:
    case 1:
      return "mention";
    case 2:
      return "command";
    case 3:
      return "custom";
    case 4:
      return "emoji";
    default:
      return "unknown";
  }
}
function $e(e) {
  return e === null ? e : {
    text: e.text,
    keyChar: Be(e),
    type: De(e)
  };
}
const x = `
`, Ue = (e) => {
  let t = e;
  return t.endsWith(x) && (t = t.slice(0, -1)), t.replaceAll(/\\/g, "");
};
async function Ge(e, t) {
  if (e.length === 0)
    return "";
  await O();
  const n = w();
  n.set_content_from_html(e);
  const s = t ? n.get_content_as_message_markdown() : n.get_content_as_markdown();
  return Ue(s);
}
async function Ve(e, t) {
  if (e.length === 0)
    return "";
  await O();
  const n = He(e), s = w();
  return s.set_content_from_markdown(n), t ? s.get_content_as_message_html() : s.get_content_as_html();
}
function He(e) {
  const { body: t } = new DOMParser().parseFromString(
    e,
    "text/html"
  ), n = document.createNodeIterator(
    t,
    void 0,
    Pe
  );
  let s = n.nextNode(), r = "";
  for (; s !== null; ) {
    const i = s.nodeName === "#text", c = s.nodeName === "A", l = s.nodeName === "DIV" && s.childNodes.length === 1 && s.firstChild?.nodeName === "BR", a = !Fe.includes(s.nodeName);
    if (l)
      r += x;
    else if (i) {
      let u = s.textContent;
      j(s) && (u += x), r += u;
    } else if (c) {
      let u = s.firstChild?.parentElement?.outerHTML ?? "";
      j(s) && (u += x), r += u;
    } else a && console.debug(`Converting unexpected node type ${s.nodeName}`);
    s = n.nextNode();
  }
  return r.endsWith(x.repeat(2)) && (r = r.slice(0, -1)), r;
}
const Fe = ["#text", "BR", "A", "DIV", "BODY"];
function j(e) {
  return (e.nextSibling || e.parentElement?.nextSibling)?.nodeName === "DIV";
}
function Pe(e) {
  return e.nodeName === "#text" && e.parentElement?.hasAttribute("data-mention-type") ? NodeFilter.FILTER_REJECT : NodeFilter.FILTER_ACCEPT;
}
function Ke(e, t = !1) {
  h(() => {
    if (t) {
      const n = setTimeout(() => e.current?.focus(), 200);
      return () => clearTimeout(n);
    }
  }, [e, t]);
}
function We() {
  const e = b(null);
  return h(() => {
    e.current?.childElementCount || e.current?.appendChild(document.createElement("br"));
  }, [e]), e;
}
function q(e) {
  const t = e?.keys();
  return t ? Array.from(t) : [];
}
function Xe(e) {
  const t = We(), n = b(null), [s, r] = E(
    q(e?.emojiSuggestions)
  );
  h(() => {
    r(q(e?.emojiSuggestions));
  }, [e?.emojiSuggestions]);
  const { composerModel: i, onError: c } = Le(
    t,
    e?.initialContent,
    s
  ), { testRef: l, utilities: a } = Re(
    t,
    i
  ), u = we(t, i), { content: o, actionStates: f, areListenersReady: m, suggestion: d } = Se(
    t,
    n,
    i,
    a,
    u,
    c,
    e?.inputEventProcessor,
    e?.emojiSuggestions
  );
  Ke(t, e?.isAutoFocusEnabled);
  const g = C(
    () => $e(d),
    [d]
  );
  return {
    ref: t,
    isWysiwygReady: m,
    wysiwyg: u,
    content: o,
    actionStates: f,
    debug: {
      modelRef: n,
      testRef: l,
      resetTestCase: a.onResetTestCase,
      traceAction: a.traceAction
    },
    suggestion: g,
    messageContent: i?.get_content_as_message_html() ?? null
  };
}
export {
  O as initOnce,
  Ve as plainToRich,
  Ge as richToPlain,
  Xe as useWysiwyg
};
