import { ComposerUpdate } from '@vector-im/matrix-wysiwyg-wasm';
import { RefObject } from 'react';

export declare const ACTION_TYPES: readonly ["bold", "italic", "strikeThrough", "underline", "undo", "redo", "orderedList", "unorderedList", "inlineCode", "clear", "link", "codeBlock", "quote", "indent", "unindent"];

export declare type ActionState = 'enabled' | 'reversed' | 'disabled';

export declare type ActionTypes = (typeof ACTION_TYPES)[number];

export declare type AllActionStates = Record<ActionTypes, ActionState>;

export declare type AllowedMentionAttributes = Map<'style' | 'data-mention-type', string>;

export declare type BlockType = InputEvent['inputType'] | 'formatInlineCode' | 'clear';

export declare type FormattingFunctions = Record<Exclude<ActionTypes, 'link'>, () => void> & {
    insertText: (text: string) => void;
    link: (url: string, text?: string) => void;
    mention: (url: string, text: string, attributes: AllowedMentionAttributes) => void;
    mentionAtRoom: (attributes: AllowedMentionAttributes) => void;
    command: (text: string) => void;
    emoji: (text: string) => void;
    removeLinks: () => void;
    getLink: () => string;
};

/**
 * Initialise the WASM module, or do nothing if it is already initialised.
 */
export declare function initOnce(): Promise<void>;

export declare type InputEventProcessor = (event: WysiwygEvent, wysiwyg: Wysiwyg, editor: HTMLElement) => WysiwygEvent | null;

export declare type LinkEvent = Omit<InputEvent, 'data'> & {
    inputType: 'insertLink';
    data: {
        url: string;
        text?: string;
    };
};

export declare type MappedSuggestion = {
    keyChar: SuggestionChar;
    text: string;
    type: SuggestionType;
};

export declare function plainToRich(plainText: string, inMessageFormat: boolean): Promise<string>;

export declare function richToPlain(richText: string, inMessageFormat: boolean): Promise<string>;

export declare type SuggestionChar = (typeof SUGGESTIONS)[number] | '';

export declare const SUGGESTIONS: readonly ["@", "#", "/", "", ":"];

export declare type SuggestionType = 'mention' | 'command' | 'custom' | 'emoji' | 'unknown';

export declare type TraceAction = (update: ComposerUpdate | null, name: string, value1?: string | number, value2?: string | number) => ComposerUpdate | null;

export declare type UseWysiwyg = {
    ref: RefObject<HTMLDivElement | null>;
    isWysiwygReady: boolean;
    wysiwyg: FormattingFunctions;
    content: string | null;
    actionStates: AllActionStates;
    debug: {
        modelRef: RefObject<HTMLDivElement | null>;
        testRef: RefObject<HTMLDivElement | null>;
        resetTestCase: () => void | null;
        traceAction: TraceAction;
    };
    suggestion: MappedSuggestion | null;
    messageContent: string | null;
};

export declare function useWysiwyg(wysiwygProps?: WysiwygProps): UseWysiwyg;

export declare type Wysiwyg = {
    actions: FormattingFunctions;
    content: () => string;
    messageContent: () => string;
};

export declare type WysiwygEvent = WysiwygInputEvent | KeyboardEvent;

export declare type WysiwygInputEvent = ClipboardEvent | LinkEvent | (InputEvent & {
    inputType: BlockType;
    data?: string | null;
});

export declare type WysiwygProps = {
    isAutoFocusEnabled?: boolean;
    inputEventProcessor?: InputEventProcessor;
    initialContent?: string;
    emojiSuggestions?: Map<string, string>;
};

export { }
