type SegmentResult = {
    segment: string;
    breakingRule?: string;
    nonBreakingRules?: string[];
} | undefined;
export interface SegmenterOptions {
    localeMatcher?: 'lookup' | 'best fit';
    granularity?: 'word' | 'sentence' | 'grapheme';
}
export interface SegmenterResolvedOptions {
    locale: string;
    granularity: NonNullable<SegmenterOptions['granularity']>;
}
declare const breaksAtResult: (breaks: boolean, matchingRule: string) => {
    breaks: boolean;
    matchingRule: string;
};
export declare class Segmenter {
    private readonly rules;
    private readonly ruleSortedKeys;
    private readonly mergedSegmentationTypeValue;
    constructor(locales: string | string[] | undefined, options: SegmenterOptions);
    breaksAt(position: number, input: string): ReturnType<typeof breaksAtResult>;
    segment(input: string): SegmentIterator;
    resolvedOptions(): SegmenterResolvedOptions;
    static availableLocales: Set<string>;
    static supportedLocalesOf(locales?: string | string[], options?: Pick<SegmenterOptions, 'localeMatcher'>): string[];
    static readonly polyfilled = true;
}
declare class SegmentIterator implements Iterable<SegmentResult>, Iterator<SegmentResult> {
    private readonly segmenter;
    private lastSegmentIndex;
    private input;
    constructor(segmenter: Segmenter, input: string);
    [Symbol.iterator](): SegmentIterator;
    next(): {
        done: boolean;
        value: {
            segment: string;
            index: number;
            input: string;
            isWordLike?: boolean;
        };
    } | {
        done: boolean;
        value: undefined;
    };
    containing(positionInput: number): {
        segment: string;
        index: number;
        input: string;
        isWordLike?: boolean;
    } | undefined;
}
export type { SegmentIterator };
