import { __assign, __spreadArray } from "tslib";
import { CanonicalizeLocaleList, GetOption, GetOptionsObject, SupportedLocales, getInternalSlot, getMultiInternalSlots, setInternalSlot, } from '@formatjs/ecma402-abstract';
import { ResolveLocale } from '@formatjs/intl-localematcher';
import { SegmentationRules } from './cldr-segmentation-rules.generated';
import { isSurrogate, replaceVariables } from './segmentation-utils';
/**
 * Adds $ to before rules and ^ to after rules for strictness
 * Replaces variables
 * Initializes the RegExp
 *
 * @param rule raw rule string from cldr-segmentation-rules.generated
 * @param variables
 * @param after appends ^ if true and $ if false
 * @returns
 */
var generateRuleRegex = function (rule, variables, after) {
    return new RegExp("".concat(after ? '^' : '').concat(replaceVariables(variables, rule)).concat(after ? '' : '$'));
};
var prepareLocaleSegmentationRules = function (segmentationTypeValue) {
    var preparedRules = {};
    for (var _i = 0, _a = Object.keys(segmentationTypeValue.segmentRules); _i < _a.length; _i++) {
        var ruleNr = _a[_i];
        var ruleValue = segmentationTypeValue.segmentRules[ruleNr];
        var preparedRule = {
            breaks: ruleValue.breaks,
        };
        if ('before' in ruleValue && ruleValue.before) {
            preparedRule.before = generateRuleRegex(ruleValue.before, segmentationTypeValue.variables, false);
        }
        if ('after' in ruleValue && ruleValue.after) {
            preparedRule.after = generateRuleRegex(ruleValue.after, segmentationTypeValue.variables, true);
        }
        preparedRules[ruleNr] = preparedRule;
    }
    return preparedRules;
};
var breaksAtResult = function (breaks, matchingRule) { return ({
    breaks: breaks,
    matchingRule: matchingRule,
}); };
var Segmenter = /** @class */ (function () {
    function Segmenter(locales, options) {
        var _newTarget = this.constructor;
        if (_newTarget === undefined) {
            throw TypeError("Constructor Intl.Segmenter requires 'new'");
        }
        var requestedLocales = CanonicalizeLocaleList(locales);
        options = GetOptionsObject(options);
        var opt = Object.create(null);
        var matcher = GetOption(options, 'localeMatcher', 'string', ['lookup', 'best fit'], 'best fit');
        opt.localeMatcher = matcher;
        var granularity = GetOption(options, 'granularity', 'string', ['word', 'sentence', 'grapheme'], 'grapheme');
        setSlot(this, 'granularity', granularity);
        //TODO: figure out correct availible locales
        var r = ResolveLocale(Segmenter.availableLocales, //availible locales
        requestedLocales, opt, [], // there is no relevantExtensionKeys
        {}, function () { return ''; } //use only root rules
        );
        setSlot(this, 'locale', r.locale);
        //root rules based on granularity
        this.mergedSegmentationTypeValue = SegmentationRules.root[granularity];
        //merge root rules with locale ones if locale is specified
        if (r.locale.length) {
            var localeOverrides = SegmentationRules[r.locale];
            if (granularity in localeOverrides) {
                var localeSegmentationTypeValue = localeOverrides[granularity];
                this.mergedSegmentationTypeValue.variables = __assign(__assign({}, this.mergedSegmentationTypeValue.variables), localeSegmentationTypeValue.variables);
                this.mergedSegmentationTypeValue.segmentRules = __assign(__assign({}, this.mergedSegmentationTypeValue.segmentRules), localeSegmentationTypeValue.segmentRules);
                this.mergedSegmentationTypeValue.suppressions = __spreadArray(__spreadArray([], this.mergedSegmentationTypeValue.suppressions, true), localeSegmentationTypeValue.suppressions, true);
            }
        }
        //prepare rules
        this.rules = prepareLocaleSegmentationRules(this.mergedSegmentationTypeValue);
        //order rule keys
        this.ruleSortedKeys = Object.keys(this.rules).sort(function (a, b) { return Number(a) - Number(b); });
    }
    Segmenter.prototype.breaksAt = function (position, input) {
        var ruleSortedKeys = this.ruleSortedKeys;
        var rules = this.rules;
        var mergedSegmentationTypeValue = this.mergedSegmentationTypeValue;
        //artificial rule 0.2
        if (position === 0) {
            return breaksAtResult(true, '0.2');
        }
        if (position === input.length) {
            //rule 0.3
            return breaksAtResult(true, '0.3');
        }
        //artificial rule 0.1: js specific, due to es5 regex not being unicode aware
        //number 0.1 chosen to mimic java implementation, but needs to execute after 0.2 and 0.3 to be inside the string bounds
        if (isSurrogate(input, position)) {
            return breaksAtResult(false, '0.1');
        }
        var stringBeforeBreak = input.substring(0, position);
        var stringAfterBreak = input.substring(position);
        //artificial rule 0.4: handle suppressions
        if ('suppressions' in mergedSegmentationTypeValue) {
            for (var _i = 0, _a = mergedSegmentationTypeValue.suppressions; _i < _a.length; _i++) {
                var suppressions = _a[_i];
                if (stringBeforeBreak.trim().endsWith(suppressions)) {
                    return breaksAtResult(false, '0.4');
                }
            }
        }
        // loop through rules and find a match
        for (var _b = 0, ruleSortedKeys_1 = ruleSortedKeys; _b < ruleSortedKeys_1.length; _b++) {
            var ruleKey = ruleSortedKeys_1[_b];
            var _c = rules[ruleKey], before = _c.before, after = _c.after, breaks = _c.breaks;
            // for debugging
            // if (ruleKey === '16' && position === 4) {
            //   console.log({before, after, stringBeforeBreak, stringAfterBreak})
            // }
            if (before) {
                if (!before.test(stringBeforeBreak)) {
                    //didn't match the before part, therfore skipping
                    continue;
                }
            }
            if (after) {
                if (!after.test(stringAfterBreak)) {
                    //didn't match the after part, therfore skipping
                    continue;
                }
            }
            return breaksAtResult(breaks, ruleKey);
        }
        //artificial rule 999: if no rule matched is Any ÷ Any so return true
        return breaksAtResult(true, '999');
    };
    Segmenter.prototype.segment = function (input) {
        checkReceiver(this, 'segment');
        return new SegmentIterator(this, input);
    };
    Segmenter.prototype.resolvedOptions = function () {
        checkReceiver(this, 'resolvedOptions');
        return __assign({}, getMultiInternalSlots(__INTERNAL_SLOT_MAP__, this, 'locale', 'granularity'));
    };
    Segmenter.supportedLocalesOf = function (locales, options) {
        return SupportedLocales(Segmenter.availableLocales, CanonicalizeLocaleList(locales), options);
    };
    Segmenter.availableLocales = new Set(Object.keys(SegmentationRules).filter(function (key) { return key !== 'root'; }));
    Segmenter.polyfilled = true;
    return Segmenter;
}());
export { Segmenter };
var createSegmentDataObject = function (segmenter, segment, index, input, matchingRule) {
    var returnValue = {
        segment: segment,
        index: index,
        input: input,
    };
    if (getSlot(segmenter, 'granularity') === 'word') {
        returnValue.isWordLike = matchingRule !== '3.1' && matchingRule !== '3.2';
    }
    return returnValue;
};
var SegmentIterator = /** @class */ (function () {
    function SegmentIterator(segmenter, input) {
        this.segmenter = segmenter;
        this.lastSegmentIndex = 0;
        if (typeof input == 'symbol') {
            throw TypeError("Input must not be a symbol");
        }
        this.input = String(input);
    }
    SegmentIterator.prototype[Symbol.iterator] = function () {
        return new SegmentIterator(this.segmenter, this.input);
    };
    SegmentIterator.prototype.next = function () {
        //using only the relevant bit of the string
        var checkString = this.input.substring(this.lastSegmentIndex);
        //loop from the start of the checkString, until exactly length (breaksAt returns break at pos=== lenght)
        for (var position = 1; position <= checkString.length; position++) {
            var _a = this.segmenter.breaksAt(position, checkString), breaks = _a.breaks, matchingRule = _a.matchingRule;
            if (breaks) {
                var segment = checkString.substring(0, position);
                var index = this.lastSegmentIndex;
                this.lastSegmentIndex += position;
                return {
                    done: false,
                    value: createSegmentDataObject(this.segmenter, segment, index, this.input, matchingRule),
                };
            }
        }
        //no segment was found by the loop, therefore the segmentation is done
        return { done: true, value: undefined };
    };
    SegmentIterator.prototype.containing = function (positionInput) {
        if (typeof positionInput === 'bigint') {
            throw TypeError('Index must not be a BigInt');
        }
        var position = Number(positionInput);
        //https://tc39.es/ecma262/#sec-tointegerorinfinity
        // 2. If number is NaN, +0𝔽, or -0𝔽, return 0.
        if (isNaN(position) || !position) {
            position = 0;
        }
        // 5. Let integer be floor(abs(ℝ(number))).
        // 6. If number < -0𝔽, set integer to -integer.
        position = Math.floor(Math.abs(position)) * (position < 0 ? -1 : 1);
        if (position < 0 || position >= this.input.length) {
            return undefined;
        }
        //find previous break point
        var previousBreakPoint = 0;
        if (position === 0) {
            previousBreakPoint = 0;
        }
        else {
            var checkString_1 = this.input;
            for (var cursor = position; cursor >= 0; cursor--) {
                var breaks = this.segmenter.breaksAt(cursor, checkString_1).breaks;
                if (breaks) {
                    previousBreakPoint = cursor;
                    break;
                }
            }
        }
        var checkString = this.input.substring(previousBreakPoint);
        //find next break point
        for (var cursor = 1; cursor <= checkString.length; cursor++) {
            var _a = this.segmenter.breaksAt(cursor, checkString), breaks = _a.breaks, matchingRule = _a.matchingRule;
            if (breaks) {
                var segment = checkString.substring(0, cursor);
                return createSegmentDataObject(this.segmenter, segment, previousBreakPoint, this.input, matchingRule);
            }
        }
    };
    return SegmentIterator;
}());
var __INTERNAL_SLOT_MAP__ = new WeakMap();
function getSlot(instance, key) {
    return getInternalSlot(__INTERNAL_SLOT_MAP__, instance, key);
}
function setSlot(instance, key, value) {
    setInternalSlot(__INTERNAL_SLOT_MAP__, instance, key, value);
}
function checkReceiver(receiver, methodName) {
    if (!(receiver instanceof Segmenter)) {
        throw TypeError("Method Intl.Segmenter.prototype.".concat(methodName, " called on incompatible receiver"));
    }
}
try {
    // IE11 does not have Symbol
    if (typeof Symbol !== 'undefined') {
        Object.defineProperty(Segmenter.prototype, Symbol.toStringTag, {
            value: 'Intl.Segmenter',
            writable: false,
            enumerable: false,
            configurable: true,
        });
    }
    //github.com/tc39/test262/blob/main/test/intl402/Segmenter/constructor/length.js
    https: Object.defineProperty(Segmenter.prototype.constructor, 'length', {
        value: 0,
        writable: false,
        enumerable: false,
        configurable: true,
    });
    // https://github.com/tc39/test262/blob/main/test/intl402/Segmenter/constructor/supportedLocalesOf/length.js
    Object.defineProperty(Segmenter.supportedLocalesOf, 'length', {
        value: 1,
        writable: false,
        enumerable: false,
        configurable: true,
    });
}
catch (e) {
    // Meta fix so we're test262-compliant, not important
}
