import { SpanAttributes } from '@sentry/core';
/**
 * Converts a PerformanceResourceTiming entry to span data for the resource span. Most importantly,
 * it converts the timing values from timestamps relative to the `performance.timeOrigin` to absolute timestamps
 * in seconds.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/PerformanceResourceTiming#timestamps
 *
 * @param resourceTiming
 * @returns An array where the first element is the attribute name and the second element is the attribute value.
 */
export declare function resourceTimingToSpanAttributes(resourceTiming: PerformanceResourceTiming): SpanAttributes;
//# sourceMappingURL=resourceTiming.d.ts.map
