/*
 * Copyright 2023 Nordeck IT + Consulting GmbH.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { IWidgetApiRequest, IWidgetApiRequestData } from "./IWidgetApiRequest";
import { IWidgetApiResponseData } from "./IWidgetApiResponse";
import { WidgetApiFromWidgetAction } from "./WidgetApiAction";

export interface IGetMediaConfigActionFromWidgetRequestData extends IWidgetApiRequestData {}

export interface IGetMediaConfigActionFromWidgetActionRequest extends IWidgetApiRequest {
    action: WidgetApiFromWidgetAction.MSC4039GetMediaConfigAction;
    data: IGetMediaConfigActionFromWidgetRequestData;
}

export interface IGetMediaConfigActionFromWidgetResponseData extends IWidgetApiResponseData {
    "m.upload.size"?: number;
}

export interface IGetMediaConfigActionFromWidgetActionResponse extends IGetMediaConfigActionFromWidgetActionRequest {
    response: IGetMediaConfigActionFromWidgetResponseData;
}
