import { IWidgetApiRequest, IWidgetApiRequestData } from "./IWidgetApiRequest";
import { WidgetApiFromWidgetAction, WidgetApiToWidgetAction } from "./WidgetApiAction";
import { IWidgetApiResponseData } from "./IWidgetApiResponse";
import { IRoomEvent } from "./IRoomEvent";
export interface ISendEventFromWidgetRequestData extends IWidgetApiRequestData {
    state_key?: string;
    type: string;
    content: unknown;
    room_id?: string;
    delay?: number;
    parent_delay_id?: string;
}
export interface ISendEventFromWidgetActionRequest extends IWidgetApiRequest {
    action: WidgetApiFromWidgetAction.SendEvent;
    data: ISendEventFromWidgetRequestData;
}
export interface ISendEventFromWidgetResponseData extends IWidgetApiResponseData {
    room_id: string;
    event_id?: string;
    delay_id?: string;
}
export interface ISendEventFromWidgetActionResponse extends ISendEventFromWidgetActionRequest {
    response: ISendEventFromWidgetResponseData;
}
export interface ISendEventToWidgetRequestData extends IWidgetApiRequestData, IRoomEvent {
}
export interface ISendEventToWidgetActionRequest extends IWidgetApiRequest {
    action: WidgetApiToWidgetAction.SendEvent;
    data: ISendEventToWidgetRequestData;
}
export interface ISendEventToWidgetResponseData extends IWidgetApiResponseData {
}
export interface ISendEventToWidgetActionResponse extends ISendEventToWidgetActionRequest {
    response: ISendEventToWidgetResponseData;
}
