#!/usr/bin/env node

"use strict";
/*
Copyright 2023 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPluralisedTranslation = exports.getTKey = exports.putTranslations = exports.getTranslations = exports.getKeys = exports.getPath = exports.OUTPUT_FILE = exports.INPUT_FILE = exports.NESTING_KEY = void 0;
const fs_1 = __importDefault(require("fs"));
const types_1 = require("@babel/types");
exports.NESTING_KEY = process.env["NESTING_KEY"] || "|";
exports.INPUT_FILE = process.env["INPUT_FILE"] || 'src/i18n/strings/en_EN.json';
exports.OUTPUT_FILE = process.env["OUTPUT_FILE"] || 'src/i18n/strings/en_EN.json';
function getPath(key) {
    return key.replace(/\\n/g, "\n").split(exports.NESTING_KEY);
}
exports.getPath = getPath;
function getKeys(translations, path = "") {
    // base case
    if (typeof translations === "string" || "other" in translations) {
        return [path];
    }
    if (path)
        path += exports.NESTING_KEY;
    return Object.keys(translations).flatMap(key => getKeys(translations[key], path + key));
}
exports.getKeys = getKeys;
function getTranslations(file = exports.INPUT_FILE) {
    return JSON.parse(fs_1.default.readFileSync(file, { encoding: 'utf8' }));
}
exports.getTranslations = getTranslations;
function putTranslations(translations, file = exports.OUTPUT_FILE) {
    fs_1.default.writeFileSync(file, JSON.stringify(translations, null, 4) + "\n");
}
exports.putTranslations = putTranslations;
function getTKey(arg) {
    if ((0, types_1.isStringLiteral)(arg)) {
        return arg.value;
    }
    else if ((0, types_1.isBinaryExpression)(arg) && arg.operator === '+') {
        return getTKey(arg.left) + getTKey(arg.right);
    }
    else if ((0, types_1.isTemplateLiteral)(arg)) {
        return arg.quasis.map(q => q.value.raw).join('');
    }
    return null;
}
exports.getTKey = getTKey;
function isPluralisedTranslation(translation) {
    return typeof translation === "object" && "other" in translation;
}
exports.isPluralisedTranslation = isPluralisedTranslation;
