/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * Authentication method used by clients
 */
export type ClientAuthMethodConfig =
    | "none"
    | "client_secret_basic"
    | "client_secret_post"
    | "client_secret_jwt"
    | "private_key_jwt";
export type JsonWebKeyFor_JsonWebKeyPublicParameters = {
    "use"?: JsonWebKeyUse;
    "key_ops"?: JsonWebKeyOperation[];
    "alg"?: JsonWebSignatureAlg;
    "kid"?: string;
    "x5u"?: string;
    "x5c"?: string[];
    "x5t"?: string;
    "x5t#S256"?: string;
    [k: string]: unknown;
} & JsonWebKeyFor_JsonWebKeyPublicParameters1;
/**
 * JSON Web Key Use
 */
export type JsonWebKeyUse = "sig" | "enc";
/**
 * JSON Web Key Operation
 */
export type JsonWebKeyOperation =
    | "sign"
    | "verify"
    | "encrypt"
    | "decrypt"
    | "wrapKey"
    | "unwrapKey"
    | "deriveKey"
    | "deriveBits";
/**
 * JSON Web Signature "alg" parameter
 */
export type JsonWebSignatureAlg =
    | "HS256"
    | "HS384"
    | "HS512"
    | "RS256"
    | "RS384"
    | "RS512"
    | "ES256"
    | "ES384"
    | "ES512"
    | "PS256"
    | "PS384"
    | "PS512"
    | "none"
    | "EdDSA"
    | "ES256K"
    | "Ed25519"
    | "Ed448";
export type JsonWebKeyFor_JsonWebKeyPublicParameters1 =
    | {
          kty: "RSA";
          n: string;
          e: string;
          [k: string]: unknown;
      }
    | {
          kty: "EC";
          crv: JsonWebKeyEcEllipticCurve;
          x: string;
          y: string;
          [k: string]: unknown;
      }
    | {
          kty: "OKP";
          crv: JsonWebKeyOkpEllipticCurve;
          x: string;
          [k: string]: unknown;
      };
/**
 * JSON Web Key EC Elliptic Curve
 */
export type JsonWebKeyEcEllipticCurve = "P-256" | "P-384" | "P-521" | "secp256k1";
/**
 * JSON Web Key OKP Elliptic Curve
 */
export type JsonWebKeyOkpEllipticCurve = "Ed25519" | "Ed448" | "X25519" | "X448";
/**
 * HTTP resources to mount
 */
export type Resource =
    | {
          name: "health";
          [k: string]: unknown;
      }
    | {
          name: "prometheus";
          [k: string]: unknown;
      }
    | {
          name: "discovery";
          [k: string]: unknown;
      }
    | {
          name: "human";
          [k: string]: unknown;
      }
    | {
          name: "graphql";
          /**
           * Enabled the GraphQL playground
           */
          playground?: boolean;
          /**
           * Allow access for OAuth 2.0 clients (undocumented)
           */
          undocumented_oauth2_access?: boolean;
          [k: string]: unknown;
      }
    | {
          name: "oauth";
          [k: string]: unknown;
      }
    | {
          name: "compat";
          [k: string]: unknown;
      }
    | {
          name: "assets";
          /**
           * Path to the directory to serve.
           */
          path?: string;
          [k: string]: unknown;
      }
    | {
          name: "adminapi";
          [k: string]: unknown;
      }
    | {
          name: "connection-info";
          [k: string]: unknown;
      };
/**
 * Configuration of a single listener
 */
export type BindConfig =
    | {
          /**
           * Host on which to listen.
           *
           * Defaults to listening on all addresses
           */
          host?: string;
          /**
           * Port on which to listen.
           */
          port: number;
          [k: string]: unknown;
      }
    | {
          /**
           * Host and port on which to listen
           */
          address: string;
          [k: string]: unknown;
      }
    | {
          /**
           * Path to the socket
           */
          socket: string;
          [k: string]: unknown;
      }
    | {
          /**
           * Index of the file descriptor. Note that this is offseted by 3 because of the standard input/output sockets, so setting here a value of `0` will grab the file descriptor `3`
           */
          fd?: number;
          /**
           * Whether the socket is a TCP socket or a UNIX domain socket. Defaults to TCP.
           */
          kind?: UnixOrTcp & string;
          [k: string]: unknown;
      };
/**
 * Kind of socket
 */
export type UnixOrTcp = "unix" | "tcp";
export type IpNetwork = V4 | V6;
export type V4 = Ipv4Network;
export type Ipv4Network = string;
export type V6 = Ipv6Network;
export type Ipv6Network = string;
export type Hostname = string;
/**
 * Options for controlling the level of protection provided for PostgreSQL SSL connections.
 */
export type PgSslMode = "disable" | "allow" | "prefer" | "require" | "verify-ca" | "verify-full";
/**
 * Exporter to use when exporting traces
 */
export type TracingExporterKind = "none" | "stdout" | "otlp";
/**
 * Propagation format for incoming and outgoing requests
 */
export type Propagator = "tracecontext" | "baggage" | "jaeger";
/**
 * Exporter to use when exporting metrics
 */
export type MetricsExporterKind = "none" | "stdout" | "otlp" | "prometheus";
/**
 * What backend should be used when sending emails
 */
export type EmailTransportKind = "blackhole" | "smtp" | "sendmail";
/**
 * Encryption mode to use
 */
export type EmailSmtpMode = "plain" | "starttls" | "tls";
/**
 * A hashing algorithm
 */
export type Algorithm = "bcrypt" | "argon2id" | "pbkdf2";
/**
 * The kind of homeserver it is.
 */
export type HomeserverKind = "synapse" | "synapse_read_only" | "synapse_legacy" | "synapse_modern";
/**
 * Authentication methods used against the OAuth 2.0 provider
 */
export type TokenAuthMethod =
    | "none"
    | "client_secret_basic"
    | "client_secret_post"
    | "client_secret_jwt"
    | "private_key_jwt"
    | "sign_in_with_apple";
/**
 * How to discover the provider's configuration
 */
export type DiscoveryMode = "oidc" | "insecure" | "disabled";
/**
 * Whether to use proof key for code exchange (PKCE) when requesting and exchanging the token.
 */
export type PkceMethod = "auto" | "always" | "never";
/**
 * The response mode we ask the provider to use for the callback
 */
export type ResponseMode = "query" | "form_post";
/**
 * How to handle a claim
 */
export type ImportAction = "ignore" | "suggest" | "force" | "require";
/**
 * How to handle an existing localpart claim
 */
export type OnConflict = "fail" | "add";
/**
 * What to do when receiving an OIDC Backchannel logout request.
 */
export type OnBackchannelLogout = "do_nothing" | "logout_browser_only" | "logout_all";
/**
 * Which service should be used for CAPTCHA protection
 */
export type CaptchaServiceKind = "recaptcha_v2" | "cloudflare_turnstile" | "hcaptcha";

/**
 * Application configuration root
 */
export interface RootConfig {
    /**
     * List of OAuth 2.0/OIDC clients config
     */
    clients?: ClientConfig[];
    /**
     * Configuration of the HTTP server
     */
    http?: HttpConfig;
    /**
     * Database connection configuration
     */
    database?: DatabaseConfig;
    /**
     * Configuration related to sending monitoring data
     */
    telemetry?: TelemetryConfig;
    /**
     * Configuration related to templates
     */
    templates?: TemplatesConfig;
    /**
     * Configuration related to sending emails
     */
    email?: EmailConfig;
    /**
     * Application secrets
     */
    secrets: SecretsConfig;
    /**
     * Configuration related to user passwords
     */
    passwords?: PasswordsConfig;
    /**
     * Configuration related to the homeserver
     */
    matrix: MatrixConfig;
    /**
     * Configuration related to the OPA policies
     */
    policy?: PolicyConfig;
    /**
     * Configuration related to limiting the rate of user actions to prevent abuse
     */
    rate_limiting?: RateLimitingConfig;
    /**
     * Configuration related to upstream OAuth providers
     */
    upstream_oauth2?: UpstreamOAuth2Config;
    /**
     * Configuration section for tweaking the branding of the service
     */
    branding?: BrandingConfig;
    /**
     * Configuration section to setup CAPTCHA protection on a few operations
     */
    captcha?: CaptchaConfig;
    /**
     * Configuration section to configure features related to account management
     */
    account?: AccountConfig;
    /**
     * Experimental configuration options
     */
    experimental?: ExperimentalConfig;
    [k: string]: unknown;
}
/**
 * An OAuth 2.0 client configuration
 */
export interface ClientConfig {
    /**
     * A ULID as per https://github.com/ulid/spec
     */
    client_id: string;
    /**
     * Authentication method used for this client
     */
    client_auth_method: ClientAuthMethodConfig;
    /**
     * Name of the `OAuth2` client
     */
    client_name?: string;
    /**
     * The client secret, used by the `client_secret_basic`, `client_secret_post` and `client_secret_jwt` authentication methods
     */
    client_secret?: string;
    /**
     * The JSON Web Key Set (JWKS) used by the `private_key_jwt` authentication method. Mutually exclusive with `jwks_uri`
     */
    jwks?: JsonWebKeySetFor_JsonWebKeyPublicParameters;
    /**
     * The URL of the JSON Web Key Set (JWKS) used by the `private_key_jwt` authentication method. Mutually exclusive with `jwks`
     */
    jwks_uri?: string;
    /**
     * List of allowed redirect URIs
     */
    redirect_uris?: string[];
    [k: string]: unknown;
}
export interface JsonWebKeySetFor_JsonWebKeyPublicParameters {
    keys: JsonWebKeyFor_JsonWebKeyPublicParameters[];
    [k: string]: unknown;
}
/**
 * Configuration related to the web server
 */
export interface HttpConfig {
    /**
     * List of listeners to run
     */
    listeners?: ListenerConfig[];
    /**
     * List of trusted reverse proxies that can set the `X-Forwarded-For` header
     */
    trusted_proxies?: IpNetwork[];
    /**
     * Public URL base from where the authentication service is reachable
     */
    public_base: string;
    /**
     * OIDC issuer URL. Defaults to `public_base` if not set.
     */
    issuer?: string;
    [k: string]: unknown;
}
/**
 * Configuration of a listener
 */
export interface ListenerConfig {
    /**
     * A unique name for this listener which will be shown in traces and in metrics labels
     */
    name?: string;
    /**
     * List of resources to mount
     */
    resources: Resource[];
    /**
     * HTTP prefix to mount the resources on
     */
    prefix?: string;
    /**
     * List of sockets to bind
     */
    binds: BindConfig[];
    /**
     * Accept `HAProxy`'s Proxy Protocol V1
     */
    proxy_protocol?: boolean;
    /**
     * If set, makes the listener use TLS with the provided certificate and key
     */
    tls?: TlsConfig;
    [k: string]: unknown;
}
/**
 * Configuration related to TLS on a listener
 */
export interface TlsConfig {
    /**
     * PEM-encoded X509 certificate chain
     *
     * Exactly one of `certificate` or `certificate_file` must be set.
     */
    certificate?: string;
    /**
     * File containing the PEM-encoded X509 certificate chain
     *
     * Exactly one of `certificate` or `certificate_file` must be set.
     */
    certificate_file?: string;
    /**
     * PEM-encoded private key
     *
     * Exactly one of `key` or `key_file` must be set.
     */
    key?: string;
    /**
     * File containing a PEM or DER-encoded private key
     *
     * Exactly one of `key` or `key_file` must be set.
     */
    key_file?: string;
    /**
     * Password used to decode the private key
     *
     * One of `password` or `password_file` must be set if the key is encrypted.
     */
    password?: string;
    /**
     * Password file used to decode the private key
     *
     * One of `password` or `password_file` must be set if the key is encrypted.
     */
    password_file?: string;
    [k: string]: unknown;
}
/**
 * Database connection configuration
 */
export interface DatabaseConfig {
    /**
     * Connection URI
     *
     * This must not be specified if `host`, `port`, `socket`, `username`, `password`, or `database` are specified.
     */
    uri?: string;
    /**
     * Name of host to connect to
     *
     * This must not be specified if `uri` is specified.
     */
    host?: Hostname;
    /**
     * Port number to connect at the server host
     *
     * This must not be specified if `uri` is specified.
     */
    port?: number;
    /**
     * Directory containing the UNIX socket to connect to
     *
     * This must not be specified if `uri` is specified.
     */
    socket?: string;
    /**
     * PostgreSQL user name to connect as
     *
     * This must not be specified if `uri` is specified.
     */
    username?: string;
    /**
     * Password to be used if the server demands password authentication
     *
     * This must not be specified if `uri` is specified.
     */
    password?: string;
    /**
     * The database name
     *
     * This must not be specified if `uri` is specified.
     */
    database?: string;
    /**
     * How to handle SSL connections
     */
    ssl_mode?: PgSslMode;
    /**
     * The PEM-encoded root certificate for SSL connections
     *
     * This must not be specified if the `ssl_ca_file` option is specified.
     */
    ssl_ca?: string;
    /**
     * Path to the root certificate for SSL connections
     *
     * This must not be specified if the `ssl_ca` option is specified.
     */
    ssl_ca_file?: string;
    /**
     * The PEM-encoded client certificate for SSL connections
     *
     * This must not be specified if the `ssl_certificate_file` option is specified.
     */
    ssl_certificate?: string;
    /**
     * Path to the client certificate for SSL connections
     *
     * This must not be specified if the `ssl_certificate` option is specified.
     */
    ssl_certificate_file?: string;
    /**
     * The PEM-encoded client key for SSL connections
     *
     * This must not be specified if the `ssl_key_file` option is specified.
     */
    ssl_key?: string;
    /**
     * Path to the client key for SSL connections
     *
     * This must not be specified if the `ssl_key` option is specified.
     */
    ssl_key_file?: string;
    /**
     * Set the maximum number of connections the pool should maintain
     */
    max_connections?: number;
    /**
     * Set the minimum number of connections the pool should maintain
     */
    min_connections?: number;
    /**
     * Set the amount of time to attempt connecting to the database
     */
    connect_timeout?: number;
    /**
     * Set a maximum idle duration for individual connections
     */
    idle_timeout?: number;
    /**
     * Set the maximum lifetime of individual connections
     */
    max_lifetime?: number;
    [k: string]: unknown;
}
/**
 * Configuration related to sending monitoring data
 */
export interface TelemetryConfig {
    /**
     * Configuration related to exporting traces
     */
    tracing?: TracingConfig;
    /**
     * Configuration related to exporting metrics
     */
    metrics?: MetricsConfig;
    /**
     * Configuration related to the Sentry integration
     */
    sentry?: SentryConfig;
    [k: string]: unknown;
}
/**
 * Configuration related to exporting traces
 */
export interface TracingConfig {
    /**
     * Exporter to use when exporting traces
     */
    exporter?: TracingExporterKind & string;
    /**
     * OTLP exporter: OTLP over HTTP compatible endpoint
     */
    endpoint?: string;
    /**
     * List of propagation formats to use for incoming and outgoing requests
     */
    propagators?: Propagator[];
    /**
     * Sample rate for traces
     *
     * Defaults to `1.0` if not set.
     */
    sample_rate?: number;
    [k: string]: unknown;
}
/**
 * Configuration related to exporting metrics
 */
export interface MetricsConfig {
    /**
     * Exporter to use when exporting metrics
     */
    exporter?: MetricsExporterKind & string;
    /**
     * OTLP exporter: OTLP over HTTP compatible endpoint
     */
    endpoint?: string;
    [k: string]: unknown;
}
/**
 * Configuration related to the Sentry integration
 */
export interface SentryConfig {
    /**
     * Sentry DSN
     */
    dsn?: string;
    /**
     * Environment to use when sending events to Sentry
     *
     * Defaults to `production` if not set.
     */
    environment?: string;
    /**
     * Sample rate for event submissions
     *
     * Defaults to `1.0` if not set.
     */
    sample_rate?: number;
    /**
     * Sample rate for tracing transactions
     *
     * Defaults to `0.0` if not set.
     */
    traces_sample_rate?: number;
    [k: string]: unknown;
}
/**
 * Configuration related to templates
 */
export interface TemplatesConfig {
    /**
     * Path to the folder which holds the templates
     */
    path?: string;
    /**
     * Path to the assets manifest
     */
    assets_manifest?: string;
    /**
     * Path to the translations
     */
    translations_path?: string;
    [k: string]: unknown;
}
/**
 * Configuration related to sending emails
 */
export interface EmailConfig {
    /**
     * Email address to use as From when sending emails
     */
    from?: string;
    /**
     * Email address to use as Reply-To when sending emails
     */
    reply_to?: string;
    /**
     * What backend should be used when sending emails
     */
    transport: EmailTransportKind;
    /**
     * SMTP transport: Connection mode to the relay
     */
    mode?: EmailSmtpMode;
    /**
     * SMTP transport: Hostname to connect to
     */
    hostname?: Hostname;
    /**
     * SMTP transport: Port to connect to. Default is 25 for plain, 465 for TLS and 587 for `StartTLS`
     */
    port?: number;
    /**
     * SMTP transport: Username for use to authenticate when connecting to the SMTP server
     *
     * Must be set if the `password` field is set
     */
    username?: string;
    /**
     * SMTP transport: Password for use to authenticate when connecting to the SMTP server
     *
     * Must be set if the `username` field is set
     */
    password?: string;
    /**
     * Sendmail transport: Command to use to send emails
     */
    command?: string;
    [k: string]: unknown;
}
/**
 * Application secrets
 */
export interface SecretsConfig {
    /**
     * List of private keys to use for signing and encrypting payloads
     */
    keys?: KeyConfig[];
    /**
     * File containing the encryption key for secure cookies.
     */
    encryption_file?: string;
    /**
     * Encryption key for secure cookies.
     */
    encryption?: string;
    [k: string]: unknown;
}
/**
 * A single key with its key ID and optional password.
 */
export interface KeyConfig {
    kid: string;
    password_file?: string;
    password?: string;
    key_file?: string;
    key?: string;
    [k: string]: unknown;
}
/**
 * User password hashing config
 */
export interface PasswordsConfig {
    /**
     * Whether password-based authentication is enabled
     */
    enabled?: boolean;
    /**
     * The hashing schemes to use for hashing and validating passwords
     *
     * The hashing scheme with the highest version number will be used for hashing new passwords.
     */
    schemes?: HashingScheme[];
    /**
     * Score between 0 and 4 determining the minimum allowed password complexity. Scores are based on the ESTIMATED number of guesses needed to guess the password.
     *
     * - 0: less than 10^2 (100) - 1: less than 10^4 (10'000) - 2: less than 10^6 (1'000'000) - 3: less than 10^8 (100'000'000) - 4: any more than that
     */
    minimum_complexity?: number;
    [k: string]: unknown;
}
/**
 * Parameters for a password hashing scheme
 */
export interface HashingScheme {
    /**
     * The version of the hashing scheme. They must be unique, and the highest version will be used for hashing new passwords.
     */
    version: number;
    /**
     * The hashing algorithm to use
     */
    algorithm: Algorithm;
    /**
     * Whether to apply Unicode normalization to the password before hashing
     *
     * Defaults to `false`, and generally recommended to stay false. This is although recommended when importing password hashs from Synapse, as it applies an NFKC normalization to the password before hashing it.
     */
    unicode_normalization?: boolean;
    /**
     * Cost for the bcrypt algorithm
     */
    cost?: number;
    /**
     * An optional secret to use when hashing passwords. This makes it harder to brute-force the passwords in case of a database leak.
     */
    secret?: string;
    /**
     * Same as `secret`, but read from a file.
     */
    secret_file?: string;
    [k: string]: unknown;
}
/**
 * Configuration related to the Matrix homeserver
 */
export interface MatrixConfig {
    /**
     * The kind of homeserver it is.
     */
    kind?: HomeserverKind & string;
    /**
     * The server name of the homeserver.
     */
    homeserver?: string;
    /**
     * Shared secret to use for calls to the admin API
     */
    secret: string;
    /**
     * The base URL of the homeserver's client API
     */
    endpoint?: string;
    [k: string]: unknown;
}
/**
 * Application secrets
 */
export interface PolicyConfig {
    /**
     * Path to the WASM module
     */
    wasm_module?: string;
    /**
     * Entrypoint to use when evaluating client registrations
     */
    client_registration_entrypoint?: string;
    /**
     * Entrypoint to use when evaluating user registrations
     */
    register_entrypoint?: string;
    /**
     * Entrypoint to use when evaluating authorization grants
     */
    authorization_grant_entrypoint?: string;
    /**
     * Entrypoint to use when changing password
     */
    password_entrypoint?: string;
    /**
     * Entrypoint to use when adding an email address
     */
    email_entrypoint?: string;
    /**
     * Arbitrary data to pass to the policy
     */
    data?: {
        [k: string]: unknown;
    };
    [k: string]: unknown;
}
/**
 * Configuration related to sending emails
 */
export interface RateLimitingConfig {
    /**
     * Account Recovery-specific rate limits
     */
    account_recovery?: AccountRecoveryRateLimitingConfig;
    /**
     * Login-specific rate limits
     */
    login?: LoginRateLimitingConfig;
    /**
     * Controls how many registrations attempts are permitted based on source address.
     */
    registration?: RateLimiterConfiguration;
    /**
     * Email authentication-specific rate limits
     */
    email_authentication?: EmailauthenticationRateLimitingConfig;
    [k: string]: unknown;
}
export interface AccountRecoveryRateLimitingConfig {
    /**
     * Controls how many account recovery attempts are permitted based on source IP address. This can protect against causing e-mail spam to many targets.
     *
     * Note: this limit also applies to re-sends.
     */
    per_ip?: RateLimiterConfiguration;
    /**
     * Controls how many account recovery attempts are permitted based on the e-mail address entered into the recovery form. This can protect against causing e-mail spam to one target.
     *
     * Note: this limit also applies to re-sends.
     */
    per_address?: RateLimiterConfiguration;
    [k: string]: unknown;
}
export interface RateLimiterConfiguration {
    /**
     * A one-off burst of actions that the user can perform in one go without waiting.
     */
    burst: number;
    /**
     * How quickly the allowance replenishes, in number of actions per second. Can be fractional to replenish slower.
     */
    per_second: number;
    [k: string]: unknown;
}
export interface LoginRateLimitingConfig {
    /**
     * Controls how many login attempts are permitted based on source IP address. This can protect against brute force login attempts.
     *
     * Note: this limit also applies to password checks when a user attempts to change their own password.
     */
    per_ip?: RateLimiterConfiguration;
    /**
     * Controls how many login attempts are permitted based on the account that is being attempted to be logged into. This can protect against a distributed brute force attack but should be set high enough to prevent someone's account being casually locked out.
     *
     * Note: this limit also applies to password checks when a user attempts to change their own password.
     */
    per_account?: RateLimiterConfiguration;
    [k: string]: unknown;
}
export interface EmailauthenticationRateLimitingConfig {
    /**
     * Controls how many email authentication attempts are permitted based on the source IP address. This can protect against causing e-mail spam to many targets.
     */
    per_ip?: RateLimiterConfiguration;
    /**
     * Controls how many email authentication attempts are permitted based on the e-mail address entered into the authentication form. This can protect against causing e-mail spam to one target.
     *
     * Note: this limit also applies to re-sends.
     */
    per_address?: RateLimiterConfiguration;
    /**
     * Controls how many authentication emails are permitted to be sent per authentication session. This ensures not too many authentication codes are created for the same authentication session.
     */
    emails_per_session?: RateLimiterConfiguration;
    /**
     * Controls how many code authentication attempts are permitted per authentication session. This can protect against brute-forcing the code.
     */
    attempt_per_session?: RateLimiterConfiguration;
    [k: string]: unknown;
}
/**
 * Upstream OAuth 2.0 providers configuration
 */
export interface UpstreamOAuth2Config {
    /**
     * List of OAuth 2.0 providers
     */
    providers: Provider[];
    [k: string]: unknown;
}
/**
 * Configuration for one upstream OAuth 2 provider.
 */
export interface Provider {
    /**
     * Whether this provider is enabled.
     *
     * Defaults to `true`
     */
    enabled?: boolean;
    /**
     * A ULID as per https://github.com/ulid/spec
     */
    id: string;
    /**
     * The ID of the provider that was used by Synapse. In order to perform a Synapse-to-MAS migration, this must be specified.
     *
     * ## For providers that used OAuth 2.0 or OpenID Connect in Synapse
     *
     * ### For `oidc_providers`: This should be specified as `oidc-` followed by the ID that was configured as `idp_id` in one of the `oidc_providers` in the Synapse configuration. For example, if Synapse's configuration contained `idp_id: wombat` for this provider, then specify `oidc-wombat` here.
     *
     * ### For `oidc_config` (legacy): Specify `oidc` here.
     */
    synapse_idp_id?: string;
    /**
     * The OIDC issuer URL
     *
     * This is required if OIDC discovery is enabled (which is the default)
     */
    issuer?: string;
    /**
     * A human-readable name for the provider, that will be shown to users
     */
    human_name?: string;
    /**
     * A brand identifier used to customise the UI, e.g. `apple`, `google`, `github`, etc.
     *
     * Values supported by the default template are:
     *
     * - `apple` - `google` - `facebook` - `github` - `gitlab` - `twitter` - `discord`
     */
    brand_name?: string;
    /**
     * The client ID to use when authenticating with the provider
     */
    client_id: string;
    /**
     * The client secret to use when authenticating with the provider
     *
     * Used by the `client_secret_basic`, `client_secret_post`, and `client_secret_jwt` methods
     */
    client_secret?: string;
    /**
     * The method to authenticate the client with the provider
     */
    token_endpoint_auth_method: TokenAuthMethod;
    /**
     * Additional parameters for the `sign_in_with_apple` method
     */
    sign_in_with_apple?: SignInWithApple;
    /**
     * The JWS algorithm to use when authenticating the client with the provider
     *
     * Used by the `client_secret_jwt` and `private_key_jwt` methods
     */
    token_endpoint_auth_signing_alg?: JsonWebSignatureAlg;
    /**
     * Expected signature for the JWT payload returned by the token authentication endpoint.
     *
     * Defaults to `RS256`.
     */
    id_token_signed_response_alg?: JsonWebSignatureAlg;
    /**
     * The scopes to request from the provider
     *
     * Defaults to `openid`.
     */
    scope?: string;
    /**
     * How to discover the provider's configuration
     *
     * Defaults to `oidc`, which uses OIDC discovery with strict metadata verification
     */
    discovery_mode?: DiscoveryMode;
    /**
     * Whether to use proof key for code exchange (PKCE) when requesting and exchanging the token.
     *
     * Defaults to `auto`, which uses PKCE if the provider supports it.
     */
    pkce_method?: PkceMethod;
    /**
     * Whether to fetch the user profile from the userinfo endpoint, or to rely on the data returned in the `id_token` from the `token_endpoint`.
     *
     * Defaults to `false`.
     */
    fetch_userinfo?: boolean;
    /**
     * Expected signature for the JWT payload returned by the userinfo endpoint.
     *
     * If not specified, the response is expected to be an unsigned JSON payload.
     */
    userinfo_signed_response_alg?: JsonWebSignatureAlg;
    /**
     * The URL to use for the provider's authorization endpoint
     *
     * Defaults to the `authorization_endpoint` provided through discovery
     */
    authorization_endpoint?: string;
    /**
     * The URL to use for the provider's userinfo endpoint
     *
     * Defaults to the `userinfo_endpoint` provided through discovery
     */
    userinfo_endpoint?: string;
    /**
     * The URL to use for the provider's token endpoint
     *
     * Defaults to the `token_endpoint` provided through discovery
     */
    token_endpoint?: string;
    /**
     * The URL to use for getting the provider's public keys
     *
     * Defaults to the `jwks_uri` provided through discovery
     */
    jwks_uri?: string;
    /**
     * The response mode we ask the provider to use for the callback
     */
    response_mode?: ResponseMode;
    /**
     * How claims should be imported from the `id_token` provided by the provider
     */
    claims_imports?: ClaimsImports;
    /**
     * Additional parameters to include in the authorization request
     *
     * Orders of the keys are not preserved.
     */
    additional_authorization_parameters?: {
        [k: string]: string;
    };
    /**
     * Whether the `login_hint` should be forwarded to the provider in the authorization request.
     *
     * Defaults to `false`.
     */
    forward_login_hint?: boolean;
    /**
     * What to do when receiving an OIDC Backchannel logout request.
     *
     * Defaults to "do_nothing".
     */
    on_backchannel_logout?: OnBackchannelLogout;
    [k: string]: unknown;
}
export interface SignInWithApple {
    /**
     * The private key file used to sign the `id_token`
     */
    private_key_file?: string;
    /**
     * The private key used to sign the `id_token`
     */
    private_key?: string;
    /**
     * The Team ID of the Apple Developer Portal
     */
    team_id: string;
    /**
     * The key ID of the Apple Developer Portal
     */
    key_id: string;
    [k: string]: unknown;
}
/**
 * How claims should be imported
 */
export interface ClaimsImports {
    /**
     * How to determine the subject of the user
     */
    subject?: SubjectImportPreference;
    /**
     * Import the localpart of the MXID
     */
    localpart?: LocalpartImportPreference;
    /**
     * Import the displayname of the user.
     */
    displayname?: DisplaynameImportPreference;
    /**
     * Import the email address of the user based on the `email` and `email_verified` claims
     */
    email?: EmailImportPreference;
    /**
     * Set a human-readable name for the upstream account for display purposes
     */
    account_name?: AccountNameImportPreference;
    [k: string]: unknown;
}
/**
 * What should be done for the subject attribute
 */
export interface SubjectImportPreference {
    /**
     * The Jinja2 template to use for the subject attribute
     *
     * If not provided, the default template is `{{ user.sub }}`
     */
    template?: string;
    [k: string]: unknown;
}
/**
 * What should be done for the localpart attribute
 */
export interface LocalpartImportPreference {
    /**
     * How to handle the attribute
     */
    action?: ImportAction;
    /**
     * The Jinja2 template to use for the localpart attribute
     *
     * If not provided, the default template is `{{ user.preferred_username }}`
     */
    template?: string;
    /**
     * How to handle conflicts on the claim, default value is `Fail`
     */
    on_conflict?: OnConflict;
    [k: string]: unknown;
}
/**
 * What should be done for the displayname attribute
 */
export interface DisplaynameImportPreference {
    /**
     * How to handle the attribute
     */
    action?: ImportAction;
    /**
     * The Jinja2 template to use for the displayname attribute
     *
     * If not provided, the default template is `{{ user.name }}`
     */
    template?: string;
    [k: string]: unknown;
}
/**
 * What should be done with the email attribute
 */
export interface EmailImportPreference {
    /**
     * How to handle the claim
     */
    action?: ImportAction;
    /**
     * The Jinja2 template to use for the email address attribute
     *
     * If not provided, the default template is `{{ user.email }}`
     */
    template?: string;
    [k: string]: unknown;
}
/**
 * What should be done for the account name attribute
 */
export interface AccountNameImportPreference {
    /**
     * The Jinja2 template to use for the account name. This name is only used for display purposes.
     *
     * If not provided, it will be ignored.
     */
    template?: string;
    [k: string]: unknown;
}
/**
 * Configuration section for tweaking the branding of the service
 */
export interface BrandingConfig {
    /**
     * A human-readable name. Defaults to the server's address.
     */
    service_name?: string;
    /**
     * Link to a privacy policy, displayed in the footer of web pages and emails. It is also advertised to clients through the `op_policy_uri` OIDC provider metadata.
     */
    policy_uri?: string;
    /**
     * Link to a terms of service document, displayed in the footer of web pages and emails. It is also advertised to clients through the `op_tos_uri` OIDC provider metadata.
     */
    tos_uri?: string;
    /**
     * Legal imprint, displayed in the footer in the footer of web pages and emails.
     */
    imprint?: string;
    /**
     * Logo displayed in some web pages.
     */
    logo_uri?: string;
    [k: string]: unknown;
}
/**
 * Configuration section to setup CAPTCHA protection on a few operations
 */
export interface CaptchaConfig {
    /**
     * Which service should be used for CAPTCHA protection
     */
    service?: CaptchaServiceKind;
    /**
     * The site key to use
     */
    site_key?: string;
    /**
     * The secret key to use
     */
    secret_key?: string;
    [k: string]: unknown;
}
/**
 * Configuration section to configure features related to account management
 */
export interface AccountConfig {
    /**
     * Whether users are allowed to change their email addresses. Defaults to `true`.
     */
    email_change_allowed?: boolean;
    /**
     * Whether users are allowed to change their display names. Defaults to `true`.
     *
     * This should be in sync with the policy in the homeserver configuration.
     */
    displayname_change_allowed?: boolean;
    /**
     * Whether to enable self-service password registration. Defaults to `false` if password authentication is enabled.
     *
     * This has no effect if password login is disabled.
     */
    password_registration_enabled?: boolean;
    /**
     * Whether users are allowed to change their passwords. Defaults to `true`.
     *
     * This has no effect if password login is disabled.
     */
    password_change_allowed?: boolean;
    /**
     * Whether email-based password recovery is enabled. Defaults to `false`.
     *
     * This has no effect if password login is disabled.
     */
    password_recovery_enabled?: boolean;
    /**
     * Whether users are allowed to delete their own account. Defaults to `true`.
     */
    account_deactivation_allowed?: boolean;
    /**
     * Whether users can log in with their email address. Defaults to `false`.
     *
     * This has no effect if password login is disabled.
     */
    login_with_email_allowed?: boolean;
    /**
     * Whether registration tokens are required for password registrations. Defaults to `false`.
     *
     * When enabled, users must provide a valid registration token during password registration. This has no effect if password registration is disabled.
     */
    registration_token_required?: boolean;
    [k: string]: unknown;
}
/**
 * Configuration sections for experimental options
 *
 * Do not change these options unless you know what you are doing.
 */
export interface ExperimentalConfig {
    /**
     * Time-to-live of access tokens in seconds. Defaults to 5 minutes.
     */
    access_token_ttl?: number;
    /**
     * Time-to-live of compatibility access tokens in seconds. Defaults to 5 minutes.
     */
    compat_token_ttl?: number;
    /**
     * Experimetal feature to automatically expire inactive sessions
     *
     * Disabled by default
     */
    inactive_session_expiration?: InactiveSessionExpirationConfig;
    /**
     * Experimental feature to show a plan management tab and iframe. This value is passed through "as is" to the client without any validation.
     */
    plan_management_iframe_uri?: string;
    [k: string]: unknown;
}
/**
 * Configuration options for the inactive session expiration feature
 */
export interface InactiveSessionExpirationConfig {
    /**
     * Time after which an inactive session is automatically finished
     */
    ttl: number;
    /**
     * Should compatibility sessions expire after inactivity
     */
    expire_compat_sessions?: boolean;
    /**
     * Should OAuth 2.0 sessions expire after inactivity
     */
    expire_oauth_sessions?: boolean;
    /**
     * Should user sessions expire after inactivity
     */
    expire_user_sessions?: boolean;
    [k: string]: unknown;
}
