import { type BrowserContext, type TestInfo } from "@playwright/test";
import { type Readable } from "node:stream";
/**
 * A logger that captures console logs from pages and testcontainers.
 */
export declare class Logger {
    private pages;
    private logs;
    /**
     * Get a consumer function that captures logs for a given container.
     * @param container - the human-readable name of the container.
     */
    getConsumer(container: string): (stream: Readable) => void;
    /**
     * Hook to call when a test starts.
     * @param context - the browser context of the test.
     */
    onTestStarted(context: BrowserContext): Promise<void>;
    /**
     * Hook to call when a test finishes.
     * @param testInfo - the info about the test that just finished.
     */
    onTestFinished(testInfo: TestInfo): Promise<void>;
}
//# sourceMappingURL=logger.d.ts.map