import { Browser } from "playwright-core";
import { Page } from "@playwright/test";
import { Credentials } from "./api.js";
import { Config } from "../index.js";
/** Create a new instance of the application, in a separate browser context, using the given credentials.
 *
 * @param browser - the browser to use
 * @param credentials - the credentials to use for the new instance
 * @param additionalConfig - additional config for the `config.json` for the new instance
 * @param labsFlags - additional labs flags for the `config.json` for the new instance
 * @param disablePresence - whether to disable presence for the new instance
 */
export declare function createNewInstance(browser: Browser, credentials: Credentials, additionalConfig?: Partial<Config>, labsFlags?: string[], disablePresence?: boolean): Promise<Page>;
//# sourceMappingURL=context.d.ts.map