import { BrowserContext, Page } from "@playwright/test";
import { Config } from "../index.js";
/** Construct a suitable config.json for the given homeserver
 *
 * @param homeserverBaseUrl - The `baseUrl` of the homeserver that the client should be configured to connect to.
 * @param additionalConfig - Additional config to add to the default config.json.
 * @param labsFlags - Lab flags to enable in the client.
 * @param disablePresence - Whether to disable presence for the given homeserver.
 */
export declare function buildConfigJson(homeserverBaseUrl: string, additionalConfig?: Partial<Config>, labsFlags?: string[], disablePresence?: boolean): Partial<Config>;
/**
 * Add a route to the browser context/page which will serve a suitable config.json for the given homeserver.
 *
 * @param context - The browser context or page to route the config.json to.
 * @param homeserverBaseUrl - The `baseUrl` of the homeserver that the client should be configured to connect to.
 * @param additionalConfig - Additional config to add to the default config.json.
 * @param labsFlags - Lab flags to enable in the client.
 * @param disablePresence - Whether to disable presence for the given homeserver.
 */
export declare function routeConfigJson(context: BrowserContext | Page, homeserverBaseUrl: string, additionalConfig?: Partial<Config>, labsFlags?: string[], disablePresence?: boolean): Promise<void>;
//# sourceMappingURL=config_json.d.ts.map