import { type APIRequestContext } from "@playwright/test";
export type Verb = "GET" | "POST" | "PUT" | "DELETE";
/**
 * A generic API client.
 */
export declare class Api {
    private readonly baseUrl;
    private _request?;
    constructor(baseUrl: string);
    /**
     * Set the request context to use for making requests.
     * @param request - The request context to use.
     */
    setRequest(request: APIRequestContext): void;
    /**
     * Make a request to the API.
     * @param verb - The HTTP verb to use.
     * @param path - The path to request.
     * @param token - The access token to use for the request.
     * @param data - The data to send with the request.
     */
    request<R extends object>(verb: "GET", path: string, token?: string, data?: never): Promise<R>;
    request<R extends object>(verb: Verb, path: string, token?: string, data?: object): Promise<R>;
}
/**
 * Credentials for a user.
 */
export interface Credentials {
    /** The base URL of the homeserver's CS API. */
    homeserverBaseUrl: string;
    accessToken: string;
    userId: string;
    deviceId: string;
    /** The domain part of the user's matrix ID. */
    homeServer: string;
    password: string | null;
    displayName?: string;
    username: string;
}
/**
 * A client-server API for interacting with a Matrix homeserver.
 */
export declare class ClientServerApi extends Api {
    constructor(baseUrl: string);
    /**
     * Register a user on the homeserver.
     * @param userId - The user ID to register.
     * @param password - The password to use for the user.
     */
    loginUser(userId: string, password: string): Promise<Omit<Credentials, "homeserverBaseUrl">>;
}
//# sourceMappingURL=api.d.ts.map