import { AbstractStartedContainer, GenericContainer, type RestartOptions, type StartedTestContainer } from "testcontainers";
import { type APIRequestContext, type TestInfo } from "@playwright/test";
import { type HomeserverContainer, type StartedHomeserverContainer } from "./HomeserverContainer.js";
import { type StartedMatrixAuthenticationServiceContainer } from "./mas.js";
import { Api, ClientServerApi, type Credentials } from "../utils/api.js";
import { StartedMailpitContainer } from "./mailpit.js";
declare const DEFAULT_CONFIG: {
    server_name: string;
    public_baseurl: string;
    pid_file: string;
    web_client: boolean;
    soft_file_limit: number;
    log_config: string;
    listeners: {
        port: number;
        tls: boolean;
        bind_addresses: string[];
        type: string;
        x_forwarded: boolean;
        resources: {
            names: string[];
            compress: boolean;
        }[];
    }[];
    database: {
        name: string;
        args: {
            database: string;
        };
    };
    rc_messages_per_second: number;
    rc_message_burst_count: number;
    rc_registration: {
        per_second: number;
        burst_count: number;
    };
    rc_joins: {
        local: {
            per_second: number;
            burst_count: number;
        };
        remote: {
            per_second: number;
            burst_count: number;
        };
    };
    rc_joins_per_room: {
        per_second: number;
        burst_count: number;
    };
    rc_3pid_validation: {
        per_second: number;
        burst_count: number;
    };
    rc_invites: {
        per_room: {
            per_second: number;
            burst_count: number;
        };
        per_user: {
            per_second: number;
            burst_count: number;
        };
    };
    rc_login: {
        address: {
            per_second: number;
            burst_count: number;
        };
        account: {
            per_second: number;
            burst_count: number;
        };
        failed_attempts: {
            per_second: number;
            burst_count: number;
        };
    };
    rc_room_creation: {
        per_second: number;
        burst_count: number;
    };
    media_store_path: string;
    max_upload_size: string;
    max_image_pixels: string;
    dynamic_thumbnails: boolean;
    enable_registration: boolean;
    enable_registration_without_verification: boolean;
    disable_msisdn_registration: boolean;
    registrations_require_3pid: never[];
    enable_metrics: boolean;
    report_stats: boolean;
    registration_shared_secret: string;
    macaroon_secret_key: string;
    form_secret: string;
    signing_key_path: string;
    trusted_key_servers: never[];
    password_config: {
        enabled: boolean;
    };
    ui_auth: {};
    background_updates: {
        min_batch_size: number;
        sleep_duration_ms: number;
    };
    enable_authenticated_media: boolean;
    email: undefined | {
        enable_notifs: boolean;
        smtp_host: string;
        smtp_port: number;
        smtp_user: string;
        smtp_pass: string;
        require_transport_security: false;
        notif_from: string;
        app_name: string;
        notif_template_html: string;
        notif_template_text: string;
        notif_for_new_users: boolean;
        client_base_url: string;
    };
    user_consent: undefined | {
        template_dir: string;
        version: string;
        server_notice_content: Record<string, unknown>;
        send_server_notice_to_guests: boolean;
        block_events_error: string;
        require_at_registration: boolean;
    };
    server_notices: undefined | {
        system_mxid_localpart: string;
        system_mxid_display_name: string;
        system_mxid_avatar_url: string;
        room_name: string;
    };
    allow_guest_access: boolean;
    experimental_features: {};
    oidc_providers: never[];
    serve_server_wellknown: boolean;
    presence: {
        enabled: boolean;
        include_offline_users_on_sync: boolean;
    };
    room_list_publication_rules: {
        action: string;
    }[];
    modules: Array<{
        module: string;
        config?: Record<string, unknown>;
    }>;
};
/**
 * Incomplete type describing the configuration for a Synapse homeserver
 */
export type SynapseConfig = typeof DEFAULT_CONFIG;
/**
 * A Synapse testcontainer
 *
 * Exposes port 8008.
 * Waits for HTTP /health 8008 to 200.
 */
export declare class SynapseContainer extends GenericContainer implements HomeserverContainer<SynapseConfig> {
    protected config: SynapseConfig;
    protected mas?: StartedMatrixAuthenticationServiceContainer;
    constructor(image?: string);
    withConfigField(key: string, value: unknown): this;
    withConfig(config: Partial<SynapseConfig>): this;
    withSmtpServer(mailpit: StartedMailpitContainer): this;
    withMatrixAuthenticationService(mas?: StartedMatrixAuthenticationServiceContainer): this;
    start(): Promise<StartedSynapseContainer>;
}
/**
 * A started Synapse testcontainer
 */
export declare class StartedSynapseContainer extends AbstractStartedContainer implements StartedHomeserverContainer {
    readonly baseUrl: string;
    private readonly registrationSharedSecret;
    protected adminTokenPromise?: Promise<string>;
    protected readonly adminApi: Api;
    readonly csApi: ClientServerApi;
    constructor(container: StartedTestContainer, baseUrl: string, registrationSharedSecret: string);
    /**
     * Restart the container
     * Useful to reset the state of the homeserver between tests
     * @param options - options to pass to the restart
     */
    restart(options?: Partial<RestartOptions>): Promise<void>;
    setRequest(request: APIRequestContext): void;
    onTestFinished(testInfo: TestInfo): Promise<void>;
    protected deletePublicRooms(): Promise<void>;
    private registerUserInternal;
    protected getAdminToken(): Promise<string>;
    private adminRequest;
    /**
     * Register a user on the given Homeserver using the shared registration secret.
     * @param username - the username of the user to register
     * @param password - the password of the user to register
     * @param displayName - optional display name to set on the newly registered user
     */
    registerUser(username: string, password: string, displayName?: string): Promise<Credentials>;
    /**
     * Logs into synapse with the given username/password
     * @param userId - login username
     * @param password - login password
     */
    loginUser(userId: string, password: string): Promise<Credentials>;
    /**
     * Binds a 3pid
     * @param userId - the username of the user to bind the 3pid to
     * @param medium - the medium of the 3pid to bind
     * @param address - the address of the 3pid to bind
     */
    setThreepid(userId: string, medium: string, address: string): Promise<void>;
}
/**
 * A started Synapse container when delegating auth to MAS
 */
export declare class StartedSynapseWithMasContainer extends StartedSynapseContainer {
    private readonly mas;
    constructor(container: StartedTestContainer, baseUrl: string, registrationSharedSecret: string, mas: StartedMatrixAuthenticationServiceContainer);
    protected getAdminToken(): Promise<string>;
    /**
     * Register a user on the given Homeserver using the shared registration secret.
     * @param username - the username of the user to register
     * @param password - the password of the user to register
     * @param displayName - optional display name to set on the newly registered user
     */
    registerUser(username: string, password: string, displayName?: string): Promise<Credentials>;
    /**
     * Binds a 3pid
     * @param userId - the username of the user to bind the 3pid to
     * @param medium - the medium of the 3pid to bind
     * @param address - the address of the 3pid to bind
     */
    setThreepid(userId: string, medium: string, address: string): Promise<void>;
}
export {};
//# sourceMappingURL=synapse.d.ts.map