import { AbstractStartedContainer, GenericContainer, type StartedTestContainer, type ExecResult } from "testcontainers";
import { type StartedPostgreSqlContainer } from "@testcontainers/postgresql";
import { type Credentials } from "../utils/api.js";
import type { RootConfig as MasConfig } from "./mas-config.js";
export { type MasConfig };
/**
 * A container running the Matrix Authentication Service.
 *
 * Exposes the MAS API on port 8080 and the health check on port 8081.
 * Waits for HTTP /health on port 8081 to be available.
 */
export declare class MatrixAuthenticationServiceContainer extends GenericContainer {
    private config;
    private readonly args;
    constructor(db: StartedPostgreSqlContainer, image?: string);
    /**
     * Adds additional configuration to the MAS config.
     * @param config - additional config fields to add
     */
    withConfig(config: Partial<MasConfig>): this;
    /**
     * Starts the MAS container
     */
    start(): Promise<StartedMatrixAuthenticationServiceContainer>;
}
/**
 * A started Matrix Authentication Service container.
 */
export declare class StartedMatrixAuthenticationServiceContainer extends AbstractStartedContainer {
    readonly baseUrl: string;
    private readonly args;
    private adminTokenPromise?;
    constructor(container: StartedTestContainer, baseUrl: string, args: string[]);
    /**
     * Retrieves a valid HS admin token
     */
    getAdminToken(): Promise<string>;
    manage(cmd: string, ...args: string[]): Promise<ExecResult>;
    private manageRegisterUser;
    private manageIssueCompatibilityToken;
    private registerUserInternal;
    /**
     * Registers a user
     *
     * @param username - the username of the user to register
     * @param password - the password of the user to register
     * @param displayName - optional display name to set on the newly registered user
     */
    registerUser(username: string, password: string, displayName?: string): Promise<Omit<Credentials, "homeserverBaseUrl">>;
    /**
     * Binds a 3pid
     * @param username - the username of the user to bind the 3pid to
     * @param medium - the medium of the 3pid to bind
     * @param address - the address of the 3pid to bind
     */
    setThreepid(username: string, medium: string, address: string): Promise<void>;
}
//# sourceMappingURL=mas.d.ts.map