import { AbstractStartedContainer, GenericContainer, type StartedTestContainer } from "testcontainers";
import { MailpitClient } from "mailpit-api";
export type { MailpitClient };
/**
 * A testcontainer for Mailpit.
 *
 * Exposes port 8025.
 * Waits for listening ports.
 * Disables SMTP authentication.
 */
export declare class MailpitContainer extends GenericContainer {
    constructor();
    /**
     * Start the Mailpit container.
     */
    start(): Promise<StartedMailpitContainer>;
}
/**
 * A started Mailpit container.
 */
export declare class StartedMailpitContainer extends AbstractStartedContainer {
    readonly client: MailpitClient;
    constructor(container: StartedTestContainer);
    /**
     * Get the hostname to use to connect to the Mailpit container from inside the docker network.
     */
    get internalHost(): string;
    /**
     * Get the port to use to connect to the Mailpit container from inside the docker network.
     */
    get internalSmtpPort(): number;
}
//# sourceMappingURL=mailpit.d.ts.map