import { type Config as BaseConfig } from "@element-hq/element-web-module-api";
export * from "./utils/config_json.js";
export * from "./utils/context.js";
export { populateLocalStorageWithCredentials } from "./fixtures/user.js";
export interface Config extends BaseConfig {
    default_server_config: {
        "m.homeserver"?: {
            base_url: string;
            server_name?: string;
        };
        "m.identity_server"?: {
            base_url: string;
            server_name?: string;
        };
    };
    enable_presence_by_hs_url?: Record<string, boolean>;
    setting_defaults: Record<string, unknown>;
    map_style_url?: string;
    features: Record<string, boolean>;
    modules?: string[];
}
export declare const CONFIG_JSON: Partial<Config>;
export interface TestFixtures {
    /**
     * The contents of the config.json to send when the client requests it.
     */
    config: Partial<typeof CONFIG_JSON>;
    labsFlags: string[];
    disablePresence: boolean;
}
export declare const test: import("playwright/test").TestType<import("playwright/test").PlaywrightTestArgs & import("playwright/test").PlaywrightTestOptions & {
    axe: import("@axe-core/playwright").AxeBuilder;
} & import("./fixtures/services.js").TestFixtures & {
    displayName?: string;
    credentials: import("./utils/api.js").Credentials;
    pageWithCredentials: import("playwright-core").Page;
    user: import("./utils/api.js").Credentials;
} & TestFixtures, import("playwright/test").PlaywrightWorkerArgs & import("playwright/test").PlaywrightWorkerOptions & import("./fixtures/services.js").WorkerOptions & import("./fixtures/services.js").Services>;
export { expect, type ToMatchScreenshotOptions } from "./expect/index.js";
//# sourceMappingURL=index.d.ts.map