import { type MailpitClient } from "mailpit-api";
import { type StartedNetwork } from "testcontainers";
import { type StartedPostgreSqlContainer } from "@testcontainers/postgresql";
import { type SynapseConfig, type StartedMatrixAuthenticationServiceContainer, type HomeserverContainer, type StartedHomeserverContainer, type StartedMailpitContainer } from "../testcontainers/index.js";
import { Logger } from "../utils/logger.js";
/**
 * Test-scoped fixtures available in the test
 */
export interface TestFixtures {
    /**
     * The mailpit client instance for the test.
     * This is a fresh client instance with no messages from prior tests.
     */
    mailpitClient: MailpitClient;
}
export interface WorkerOptions {
    /**
     * The synapse configuration to use for the homeserver.
     */
    synapseConfig: Partial<SynapseConfig>;
}
/**
 * Worker-scoped "service" fixtures available in the test
 */
export interface Services {
    /**
     * The logger instance for the worker.
     */
    logger: Logger;
    /**
     * The started testcontainers network instance for the worker.
     */
    network: StartedNetwork;
    /**
     * The started postgres container instance for the worker.
     */
    postgres: StartedPostgreSqlContainer;
    /**
     * The started mailpit container instance for the worker.
     */
    mailpit: StartedMailpitContainer;
    /**
     * The homeserver instance container to use for the worker.
     */
    _homeserver: HomeserverContainer<unknown>;
    /**
     * The started homeserver instance container for the worker.
     */
    homeserver: StartedHomeserverContainer;
    /**
     * The Matrix Authentication Service container instance for the worker.
     * May be undefined if no delegated auth is in use.
     */
    mas?: StartedMatrixAuthenticationServiceContainer;
}
export declare const test: import("playwright/test").TestType<import("playwright/test").PlaywrightTestArgs & import("playwright/test").PlaywrightTestOptions & TestFixtures, import("playwright/test").PlaywrightWorkerArgs & import("playwright/test").PlaywrightWorkerOptions & WorkerOptions & Services>;
//# sourceMappingURL=services.d.ts.map